/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.entity.living.monster;

import com.degoos.wetsponge.entity.living.monster.Spigot13Monster;
import com.degoos.wetsponge.entity.living.monster.WSZombie;
import com.degoos.wetsponge.enums.EnumEquipType;
import com.degoos.wetsponge.item.Spigot13ItemStack;
import com.degoos.wetsponge.item.WSItemStack;
import java.util.Optional;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Zombie;
import org.bukkit.inventory.ItemStack;

public class Spigot13Zombie
extends Spigot13Monster
implements WSZombie {
    public Spigot13Zombie(Zombie entity) {
        super((Monster)entity);
    }

    @Override
    public int getAge() {
        return this.getHandled().isBaby() ? -1 : 0;
    }

    @Override
    public void setAge(int age) {
        this.setBaby(age < 0);
    }

    @Override
    public boolean isBaby() {
        return this.getHandled().isBaby();
    }

    @Override
    public void setBaby(boolean baby) {
        this.getHandled().setBaby(baby);
    }

    @Override
    public boolean isAdult() {
        return !this.getHandled().isBaby();
    }

    @Override
    public void setAdult(boolean adult) {
        this.getHandled().setBaby(!adult);
    }

    @Override
    public Optional<WSItemStack> getEquippedItem(EnumEquipType type) {
        ItemStack itemStack = null;
        switch (type) {
            case HELMET: {
                itemStack = this.getHandled().getEquipment().getHelmet();
                break;
            }
            case CHESTPLATE: {
                itemStack = this.getHandled().getEquipment().getChestplate();
                break;
            }
            case LEGGINGS: {
                itemStack = this.getHandled().getEquipment().getLeggings();
                break;
            }
            case BOOTS: {
                itemStack = this.getHandled().getEquipment().getBoots();
                break;
            }
            case MAIN_HAND: {
                itemStack = this.getHandled().getEquipment().getItemInHand();
                break;
            }
            case OFF_HAND: {
                itemStack = this.getHandled().getEquipment().getItemInOffHand();
            }
        }
        return Optional.ofNullable(itemStack).map(Spigot13ItemStack::new);
    }

    @Override
    public void setEquippedItem(EnumEquipType type, WSItemStack itemStack) {
        switch (type) {
            case HELMET: {
                this.getHandled().getEquipment().setHelmet(itemStack == null ? null : ((Spigot13ItemStack)itemStack).getHandled().clone());
                break;
            }
            case CHESTPLATE: {
                this.getHandled().getEquipment().setChestplate(itemStack == null ? null : ((Spigot13ItemStack)itemStack).getHandled().clone());
                break;
            }
            case LEGGINGS: {
                this.getHandled().getEquipment().setLeggings(itemStack == null ? null : ((Spigot13ItemStack)itemStack).getHandled().clone());
                break;
            }
            case BOOTS: {
                this.getHandled().getEquipment().setBoots(itemStack == null ? null : ((Spigot13ItemStack)itemStack).getHandled().clone());
                break;
            }
            case MAIN_HAND: {
                this.getHandled().getEquipment().setItemInHand(itemStack == null ? null : ((Spigot13ItemStack)itemStack).getHandled().clone());
                break;
            }
            case OFF_HAND: {
                this.getHandled().getEquipment().setItemInOffHand(itemStack == null ? null : ((Spigot13ItemStack)itemStack).getHandled().clone());
            }
        }
    }

    public Zombie getHandled() {
        return (Zombie)super.getHandled();
    }
}

