/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.entity.living.monster;

import com.degoos.wetsponge.entity.living.monster.Spigot13Monster;
import com.degoos.wetsponge.entity.living.monster.WSEnderman;
import com.degoos.wetsponge.material.WSBlockTypes;
import com.degoos.wetsponge.material.block.Spigot13BlockType;
import com.degoos.wetsponge.material.block.WSBlockType;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Monster;

public class Spigot13Enderman
extends Spigot13Monster
implements WSEnderman {
    public Spigot13Enderman(Enderman entity) {
        super((Monster)entity);
    }

    @Override
    public Optional<WSBlockType> getCarriedBlock() {
        BlockData blockData = this.getHandled().getCarriedBlock();
        if (blockData == null || blockData.getMaterial().equals((Object)Material.AIR)) {
            return Optional.empty();
        }
        String id = blockData.getMaterial().getKey().toString();
        Optional<WSBlockType> optional = WSBlockTypes.getById(id);
        if (optional.isPresent()) {
            return optional.map(target -> ((Spigot13BlockType)target).readBlockData(blockData));
        }
        return Optional.of(new Spigot13BlockType(-1, id, id, blockData.getMaterial().getMaxStackSize()));
    }

    @Override
    public void setCarriedBlock(WSBlockType carriedMaterial) {
        if (carriedMaterial == null) {
            this.getHandled().setCarriedBlock(null);
        } else {
            this.getHandled().setCarriedBlock(((Spigot13BlockType)carriedMaterial).toBlockData());
        }
    }

    public Enderman getHandled() {
        return (Enderman)super.getHandled();
    }
}

