/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.entity.living.monster;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.entity.living.monster.Spigot13Monster;
import com.degoos.wetsponge.entity.living.monster.WSCreeper;
import com.degoos.wetsponge.enums.EnumServerVersion;
import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.util.reflection.NMSUtils;
import com.degoos.wetsponge.util.reflection.ReflectionUtils;
import com.degoos.wetsponge.util.reflection.Spigot13HandledUtils;
import java.lang.reflect.Field;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Monster;

public class Spigot13Creeper
extends Spigot13Monster
implements WSCreeper {
    private static Field[] fields = NMSUtils.getNMSClass("EntityCreeper").getDeclaredFields();
    private Object handled;

    public Spigot13Creeper(Creeper entity) {
        super((Monster)entity);
        this.handled = Spigot13HandledUtils.getEntityHandle((Entity)entity);
    }

    @Override
    public boolean isPowered() {
        return this.getHandled().isPowered();
    }

    @Override
    public void setPowered(boolean powered) {
        this.getHandled().setPowered(powered);
    }

    @Override
    public int getFuseDuration() {
        try {
            return ReflectionUtils.setAccessible(fields[2]).getInt(this.handled);
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was getting the fuse duration of a creeper!");
            return 0;
        }
    }

    @Override
    public void setFuseDuration(int fuseDuration) {
        try {
            ReflectionUtils.setAccessible(fields[2]).setInt(this.handled, fuseDuration);
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was setting the fuse duration of a creeper!");
        }
    }

    @Override
    public int getTicksRemaining() {
        try {
            return this.getFuseDuration() - ReflectionUtils.setAccessible(fields[1]).getInt(this.handled);
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was getting the remaining ticks of a creeper!");
            return 0;
        }
    }

    @Override
    public void setTicksRemaining(int ticksRemaining) {
        try {
            ReflectionUtils.setAccessible(fields[1]).setInt(this.handled, this.getFuseDuration() - ticksRemaining);
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was setting the remaining ticks of a creeper!");
        }
    }

    @Override
    public boolean isPrimed() {
        try {
            return (Boolean)ReflectionUtils.invokeMethod(this.handled, WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD) ? "isIgnited" : "cn", new Object[0]);
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was checking if a creeper is primed!");
            return false;
        }
    }

    @Override
    public void prime() {
        try {
            ReflectionUtils.invokeMethod(this.handled, WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD) ? "co" : "do_", new Object[0]);
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was priming a creeper!");
            return;
        }
    }

    @Override
    public void defuse() {
    }

    @Override
    public int setExplosionRadius() {
        try {
            return ReflectionUtils.setAccessible(fields[3]).getInt(this.handled);
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was getting the explosion radius of a creeper!");
            return 0;
        }
    }

    @Override
    public void setExplosionRadius(int explosionRadius) {
        try {
            ReflectionUtils.setAccessible(fields[3]).setInt(this.handled, explosionRadius);
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was setting the explosion radius of a creeper!");
        }
    }

    @Override
    public void detonate() {
        try {
            ReflectionUtils.invokeMethod(this.handled, WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD) ? "cr" : "dr", new Object[0]);
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was detonating a creeper!");
            return;
        }
    }

    public Creeper getHandled() {
        return (Creeper)super.getHandled();
    }
}

