/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.entity.living.merchant;

import com.degoos.wetsponge.entity.living.SpongeAgeable;
import com.degoos.wetsponge.entity.living.merchant.WSVillager;
import com.degoos.wetsponge.entity.living.player.SpongePlayer;
import com.degoos.wetsponge.entity.living.player.WSPlayer;
import com.degoos.wetsponge.enums.EnumVillagerProfession;
import com.degoos.wetsponge.merchant.SpongeTrade;
import com.degoos.wetsponge.merchant.WSTrade;
import com.degoos.wetsponge.parser.player.PlayerParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.Career;
import org.spongepowered.api.entity.living.Ageable;
import org.spongepowered.api.entity.living.Humanoid;
import org.spongepowered.api.entity.living.Villager;

public class SpongeVillager
extends SpongeAgeable
implements WSVillager {
    public SpongeVillager(Villager entity) {
        super((Ageable)entity);
    }

    @Override
    public EnumVillagerProfession getProfession() {
        return EnumVillagerProfession.getBySpongeName(((Career)this.getHandled().career().get()).getName()).orElseThrow(NullPointerException::new);
    }

    @Override
    public void setProfession(EnumVillagerProfession profession) {
        this.getHandled().offer(Keys.CAREER, Sponge.getRegistry().getType(Career.class, profession.getSpongeName()).orElseThrow(NullPointerException::new));
    }

    @Override
    public Optional<WSPlayer> getCustomer() {
        return this.getHandled().getCustomer().map(target -> PlayerParser.getPlayer(target.getUniqueId()).orElse(null)).filter(Objects::nonNull);
    }

    @Override
    public void setCustomer(WSPlayer player) {
        if (player == null) {
            this.getHandled().setCustomer(null);
        } else {
            ((EntityVillager)this.getHandled()).func_184645_a((EntityPlayer)player.getHandled(), EnumHand.MAIN_HAND);
            this.getHandled().setCustomer((Humanoid)((SpongePlayer)player).getHandled());
        }
    }

    @Override
    public List<WSTrade> getTrades() {
        return ((List)this.getHandled().get(Keys.TRADE_OFFERS).orElse(new ArrayList())).stream().map(SpongeTrade::new).collect(Collectors.toList());
    }

    @Override
    public void setTrades(List<WSTrade> trades) {
        this.getHandled().offer(Keys.TRADE_OFFERS, trades.stream().map(trade -> ((SpongeTrade)trade).getHandled()).collect(Collectors.toList()));
    }

    @Override
    public void addTrade(WSTrade trade) {
        List trades = this.getHandled().get(Keys.TRADE_OFFERS).orElse(new ArrayList());
        trades.add(((SpongeTrade)trade).getHandled());
        this.getHandled().offer(Keys.TRADE_OFFERS, (Object)trades);
    }

    @Override
    public void removeTrade(WSTrade trade) {
        this.getHandled().offer(Keys.TRADE_OFFERS, ((List)this.getHandled().get(Keys.TRADE_OFFERS).orElse(new ArrayList())).stream().filter(target -> target.equals(((SpongeTrade)trade).getHandled())).collect(Collectors.toList()));
    }

    @Override
    public void clearTrades() {
        this.getHandled().offer(Keys.TRADE_OFFERS, new ArrayList());
    }

    public Villager getHandled() {
        return (Villager)super.getHandled();
    }
}

