/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.entity.living.animal;

import com.degoos.wetsponge.entity.living.animal.SpongeAnimal;
import com.degoos.wetsponge.entity.living.animal.WSWolf;
import com.degoos.wetsponge.enums.EnumDyeColor;
import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.DyeColor;
import org.spongepowered.api.data.type.DyeColors;
import org.spongepowered.api.entity.living.animal.Animal;
import org.spongepowered.api.entity.living.animal.Wolf;

public class SpongeWolf
extends SpongeAnimal
implements WSWolf {
    public SpongeWolf(Wolf entity) {
        super((Animal)entity);
    }

    @Override
    public EnumDyeColor getCollarColor() {
        return EnumDyeColor.getByName(this.getHandled().get(Keys.DYE_COLOR).orElse(DyeColors.RED).getName()).orElse(EnumDyeColor.RED);
    }

    @Override
    public void setCollarColor(EnumDyeColor collarColor) {
        this.getHandled().offer(Keys.DYE_COLOR, (Object)Sponge.getRegistry().getType(DyeColor.class, collarColor.getName()).orElse(DyeColors.RED));
    }

    @Override
    public boolean isAngry() {
        return this.getHandled().get(Keys.ANGRY).orElse(false);
    }

    @Override
    public void setAngry(boolean angry) {
        this.getHandled().offer(Keys.ANGRY, (Object)angry);
    }

    @Override
    public boolean isSitting() {
        return this.getHandled().get(Keys.IS_SITTING).orElse(false);
    }

    @Override
    public void setSitting(boolean sitting) {
        this.getHandled().offer(Keys.IS_SITTING, (Object)sitting);
    }

    @Override
    public boolean isTamed() {
        return this.getHandled().get(Keys.TAMED_OWNER).orElse(Optional.empty()).isPresent();
    }

    @Override
    public Optional<UUID> getTamer() {
        return this.getHandled().get(Keys.TAMED_OWNER).orElse(Optional.empty());
    }

    @Override
    public void setTamer(UUID tamer) {
        this.getHandled().offer(Keys.TAMED_OWNER, Optional.ofNullable(tamer));
    }

    public Wolf getHandled() {
        return (Wolf)super.getHandled();
    }
}

