/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.entity.living.animal;

import com.degoos.wetsponge.entity.living.animal.SpongeAnimal;
import com.degoos.wetsponge.entity.living.animal.WSOcelot;
import com.degoos.wetsponge.enums.EnumOcelotType;
import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.OcelotType;
import org.spongepowered.api.data.type.OcelotTypes;
import org.spongepowered.api.entity.living.animal.Animal;
import org.spongepowered.api.entity.living.animal.Ocelot;

public class SpongeOcelot
extends SpongeAnimal
implements WSOcelot {
    public SpongeOcelot(Ocelot entity) {
        super((Animal)entity);
    }

    @Override
    public EnumOcelotType getOcelotType() {
        return EnumOcelotType.getByName(((OcelotType)this.getHandled().variant().get()).getName()).orElse(EnumOcelotType.WILD_OCELOT);
    }

    @Override
    public void setOcelotType(EnumOcelotType ocelotType) {
        this.getHandled().offer(Keys.OCELOT_TYPE, (Object)Sponge.getRegistry().getType(OcelotType.class, ocelotType.name()).orElse(OcelotTypes.WILD_OCELOT));
    }

    @Override
    public boolean isSitting() {
        return this.getHandled().get(Keys.IS_SITTING).orElse(false);
    }

    @Override
    public void setSitting(boolean sitting) {
        this.getHandled().offer(Keys.IS_SITTING, (Object)sitting);
    }

    @Override
    public boolean isTamed() {
        return this.getHandled().get(Keys.TAMED_OWNER).orElse(Optional.empty()).isPresent();
    }

    @Override
    public Optional<UUID> getTamer() {
        return this.getHandled().get(Keys.TAMED_OWNER).orElse(Optional.empty());
    }

    @Override
    public void setTamer(UUID tamer) {
        this.getHandled().offer(Keys.TAMED_OWNER, Optional.ofNullable(tamer));
    }

    public Ocelot getHandled() {
        return (Ocelot)super.getHandled();
    }
}

