/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.entity.living.animal;

import com.degoos.wetsponge.entity.living.animal.SpongeAbstractHorse;
import com.degoos.wetsponge.entity.living.animal.WSLlama;
import com.degoos.wetsponge.enums.EnumLlamaType;
import com.degoos.wetsponge.inventory.SpongeInventory;
import com.degoos.wetsponge.inventory.WSInventory;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.passive.AbstractChestHorse;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.LlamaVariant;
import org.spongepowered.api.data.type.LlamaVariants;
import org.spongepowered.api.entity.living.animal.Horse;
import org.spongepowered.api.entity.living.animal.Llama;
import org.spongepowered.api.item.inventory.Inventory;

public class SpongeLlama
extends SpongeAbstractHorse
implements WSLlama {
    public SpongeLlama(Llama entity) {
        super((Horse)entity);
    }

    @Override
    public boolean isTamed() {
        return this.getHandled().get(Keys.TAMED_OWNER).orElse(Optional.empty()).isPresent();
    }

    @Override
    public Optional<UUID> getTamer() {
        return this.getHandled().get(Keys.TAMED_OWNER).orElse(Optional.empty());
    }

    @Override
    public void setTamer(UUID tamer) {
        this.getHandled().offer(Keys.TAMED_OWNER, Optional.ofNullable(tamer));
    }

    @Override
    public EnumLlamaType getLlamaType() {
        return EnumLlamaType.getByName(((LlamaVariant)this.getHandled().llamaVariant().get()).getName()).orElse(EnumLlamaType.CREAMY);
    }

    @Override
    public boolean hasChest() {
        return ((AbstractChestHorse)this.getHandled()).func_190695_dh();
    }

    @Override
    public void setChested(boolean chested) {
        ((AbstractChestHorse)this.getHandled()).func_110207_m(chested);
    }

    @Override
    public void setLlamaType(EnumLlamaType llamaType) {
        this.getHandled().offer(Keys.LLAMA_VARIANT, (Object)Sponge.getRegistry().getType(LlamaVariant.class, llamaType.name()).orElse(LlamaVariants.CREAMY));
    }

    @Override
    public WSInventory getInventory() {
        return new SpongeInventory((Inventory)this.getHandled().getInventory());
    }

    public Llama getHandled() {
        return (Llama)super.getHandled();
    }
}

