/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.entity.living.animal;

import com.degoos.wetsponge.entity.living.animal.SpongeAnimal;
import com.degoos.wetsponge.entity.living.animal.WSAbstractHorse;
import com.degoos.wetsponge.mixin.sponge.interfaces.WSMixinAbstractHorse;
import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.util.reflection.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.passive.AbstractHorse;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.animal.Animal;
import org.spongepowered.api.entity.living.animal.Horse;

public class SpongeAbstractHorse
extends SpongeAnimal
implements WSAbstractHorse {
    public SpongeAbstractHorse(Horse entity) {
        super((Animal)entity);
    }

    @Override
    public int getDomestication() {
        return ((AbstractHorse)this.getHandled()).func_110252_cg();
    }

    @Override
    public void setDomestication(int domestication) {
        ((AbstractHorse)this.getHandled()).func_110238_s(domestication);
    }

    @Override
    public int getMaxDomestication() {
        return ((AbstractHorse)this.getHandled()).func_190676_dC();
    }

    @Override
    public void setMaxDomestication(int maxDomestication) {
        ((WSMixinAbstractHorse)this.getHandled()).setMaxTemper(maxDomestication);
    }

    @Override
    public double getJumpStrength() {
        return ((AbstractHorse)this.getHandled()).func_110215_cj();
    }

    @Override
    public void setJumpStrength(double jumpStrength) {
        try {
            Field field = ReflectionUtils.getFirstField(AbstractHorse.class, IAttribute.class);
            field.setAccessible(true);
            ((AbstractHorse)this.getHandled()).func_110148_a((IAttribute)field.get(null)).func_111128_a(jumpStrength);
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred white WetSponge was setting the jump strength of a horse!");
        }
    }

    @Override
    public boolean isTamed() {
        return this.getHandled().get(Keys.TAMED_OWNER).orElse(Optional.empty()).isPresent();
    }

    @Override
    public Optional<UUID> getTamer() {
        return this.getHandled().get(Keys.TAMED_OWNER).orElse(Optional.empty());
    }

    @Override
    public void setTamer(UUID tamer) {
        this.getHandled().offer(Keys.TAMED_OWNER, Optional.ofNullable(tamer));
    }

    @Override
    public boolean hasSaddle() {
        return this.getHandled().get(Keys.PIG_SADDLE).orElse(false);
    }

    @Override
    public void setSaddle(boolean saddle) {
        this.getHandled().offer(Keys.PIG_SADDLE, (Object)saddle);
    }

    public Horse getHandled() {
        return (Horse)super.getHandled();
    }
}

