/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.entity.living;

import com.degoos.wetsponge.effect.potion.SpongePotionEffect;
import com.degoos.wetsponge.effect.potion.WSPotionEffect;
import com.degoos.wetsponge.entity.SpongeEntity;
import com.degoos.wetsponge.entity.WSEntity;
import com.degoos.wetsponge.entity.living.WSLivingEntity;
import com.degoos.wetsponge.entity.living.player.WSPlayer;
import com.degoos.wetsponge.entity.projectile.WSProjectile;
import com.degoos.wetsponge.enums.EnumEntityType;
import com.degoos.wetsponge.enums.EnumPotionEffectType;
import com.degoos.wetsponge.packet.play.server.WSSPacketDestroyEntities;
import com.degoos.wetsponge.packet.play.server.WSSPacketSpawnMob;
import com.degoos.wetsponge.packet.play.server.WSSPacketSpawnPlayer;
import com.degoos.wetsponge.parser.entity.SpongeEntityParser;
import com.flowpowered.math.vector.Vector3d;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.property.entity.EyeLocationProperty;
import org.spongepowered.api.entity.living.Living;

public class SpongeLivingEntity
extends SpongeEntity
implements WSLivingEntity {
    private WSLivingEntity disguise = null;

    public SpongeLivingEntity(Living entity) {
        super((org.spongepowered.api.entity.Entity)entity);
    }

    @Override
    public boolean isAlive() {
        return this.getHealth() > 0.0;
    }

    @Override
    public void kill() {
        this.setHealth(0.0);
    }

    @Override
    public double getHealth() {
        return (Double)this.getHandled().health().get();
    }

    @Override
    public void setHealth(double health) {
        this.getHandled().offer(Keys.HEALTH, (Object)health);
    }

    @Override
    public double getMaxHealth() {
        return (Double)this.getHandled().maxHealth().get();
    }

    @Override
    public void setMaxHealth(double maxHealth) {
        this.getHandled().offer(Keys.MAX_HEALTH, (Object)maxHealth);
    }

    @Override
    public Vector3d getRotation() {
        return this.getHandled().getRotation();
    }

    @Override
    public void setRotation(Vector3d rotation) {
        this.getHandled().setRotation(rotation);
    }

    @Override
    public Vector3d getHeadRotation() {
        return this.getHandled().getHeadRotation();
    }

    @Override
    public double getEyeHeight() {
        return this.getHandled().getProperty(EyeLocationProperty.class).map(target -> ((Vector3d)target.getValue()).getY()).map(target -> target - this.getHandled().getLocation().getPosition().getY()).orElse(0.0);
    }

    @Override
    public void setHeadRotation(Vector3d rotation) {
        this.getHandled().setHeadRotation(rotation);
    }

    @Override
    public void lookAt(Vector3d targetPosition) {
        this.getHandled().lookAt(targetPosition);
    }

    @Override
    public Optional<WSLivingEntity> getDisguise() {
        return Optional.ofNullable(this.disguise);
    }

    @Override
    public void setDisguise(WSLivingEntity disguise) {
        WSSPacketSpawnMob spawnPacket;
        WSSPacketDestroyEntities removePacket;
        if (this.disguise != null && disguise == null) {
            removePacket = WSSPacketDestroyEntities.of(this.getEntityId());
            spawnPacket = this instanceof WSPlayer ? WSSPacketSpawnPlayer.of((WSPlayer)((Object)this)) : WSSPacketSpawnMob.of(this);
            this.getWorld().getPlayers().forEach(player -> {
                if (player.equals(this)) {
                    return;
                }
                player.sendPacket(removePacket);
                player.sendPacket(spawnPacket);
            });
        }
        if (disguise != null) {
            removePacket = WSSPacketDestroyEntities.of(this.getEntityId());
            spawnPacket = WSSPacketSpawnMob.of(this);
            this.getWorld().getPlayers().forEach(player -> {
                if (player.equals(this)) {
                    return;
                }
                player.sendPacket(removePacket);
                player.sendPacket(spawnPacket);
            });
        }
        this.disguise = disguise;
    }

    @Override
    public boolean hasDisguise() {
        return this.disguise != null;
    }

    @Override
    public void clearDisguise() {
        this.setDisguise(null);
    }

    @Override
    public Optional<WSEntity> getLeashHolder() {
        return Optional.ofNullable(((EntityLiving)this.getHandled()).func_110166_bE()).map(target -> (org.spongepowered.api.entity.Entity)target).map(SpongeEntityParser::getWSEntity);
    }

    @Override
    public void setLeashHolder(WSEntity entity) {
        ((EntityLiving)this.getHandled()).func_110162_b((Entity)((SpongeEntity)entity).getHandled(), true);
    }

    @Override
    public void addPotionEffect(WSPotionEffect effect) {
        List list = this.getHandled().get(Keys.POTION_EFFECTS).orElse(new ArrayList());
        list.add(((SpongePotionEffect)effect).getHandled());
        this.getHandled().offer(Keys.POTION_EFFECTS, (Object)list);
    }

    @Override
    public List<WSPotionEffect> getPotionEffects() {
        return ((List)this.getHandled().get(Keys.POTION_EFFECTS).orElse(new ArrayList())).stream().map(SpongePotionEffect::new).collect(Collectors.toList());
    }

    @Override
    public void clearAllPotionEffects() {
        this.getHandled().offer(Keys.POTION_EFFECTS, new ArrayList());
    }

    @Override
    public void removePotionEffect(EnumPotionEffectType potionEffectType) {
        this.getHandled().offer(Keys.POTION_EFFECTS, ((List)this.getHandled().get(Keys.POTION_EFFECTS).orElse(new ArrayList())).stream().filter(potionEffect -> !potionEffect.getType().getId().equalsIgnoreCase(potionEffectType.getId())).collect(Collectors.toList()));
    }

    @Override
    public <T extends WSProjectile> Optional<T> launchProjectile(Class<T> projectile) {
        return this.launchProjectile(projectile, new Vector3d(0.0f, 0.0f, 0.0f));
    }

    @Override
    public <T extends WSProjectile> Optional<T> launchProjectile(Class<T> projectile, Vector3d velocity) {
        EnumEntityType type = EnumEntityType.getByClass(projectile).orElse(EnumEntityType.UNKNOWN);
        if (type == EnumEntityType.UNKNOWN) {
            return Optional.empty();
        }
        try {
            Class<? extends org.spongepowered.api.entity.Entity> spongeClass = SpongeEntityParser.getEntityData(type).getEntityClass();
            return this.getHandled().launchProjectile(spongeClass).map(entity -> (WSProjectile)SpongeEntityParser.getWSEntity((org.spongepowered.api.entity.Entity)entity));
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return Optional.empty();
        }
    }

    public Living getHandled() {
        return (Living)super.getHandled();
    }
}

