/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.entity.living;

import com.degoos.wetsponge.effect.potion.SpigotPotionEffect;
import com.degoos.wetsponge.effect.potion.WSPotionEffect;
import com.degoos.wetsponge.entity.SpigotEntity;
import com.degoos.wetsponge.entity.WSEntity;
import com.degoos.wetsponge.entity.living.WSLivingEntity;
import com.degoos.wetsponge.entity.living.player.WSPlayer;
import com.degoos.wetsponge.entity.projectile.WSProjectile;
import com.degoos.wetsponge.enums.EnumEntityType;
import com.degoos.wetsponge.enums.EnumPotionEffectType;
import com.degoos.wetsponge.packet.play.server.WSSPacketDestroyEntities;
import com.degoos.wetsponge.packet.play.server.WSSPacketSpawnMob;
import com.degoos.wetsponge.packet.play.server.WSSPacketSpawnPlayer;
import com.degoos.wetsponge.parser.entity.SpigotEntityParser;
import com.flowpowered.math.vector.Vector2d;
import com.flowpowered.math.vector.Vector3d;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class SpigotLivingEntity
extends SpigotEntity
implements WSLivingEntity {
    private WSLivingEntity disguise = null;

    public SpigotLivingEntity(LivingEntity entity) {
        super((Entity)entity);
    }

    @Override
    public boolean isAlive() {
        return !this.getHandled().isDead();
    }

    @Override
    public void kill() {
        this.setHealth(0.0);
    }

    @Override
    public double getHealth() {
        return this.getHandled().getHealth();
    }

    @Override
    public void setHealth(double health) {
        this.getHandled().setHealth(health);
    }

    @Override
    public double getMaxHealth() {
        return this.getHandled().getMaxHealth();
    }

    @Override
    public void setMaxHealth(double maxHealth) {
        this.getHandled().setMaxHealth(maxHealth);
    }

    @Override
    public Vector3d getRotation() {
        return new Vector3d(this.getHandled().getLocation().getPitch(), this.getHandled().getLocation().getYaw(), 0.0f);
    }

    @Override
    public void setRotation(Vector3d rotation) {
        Location location = this.getHandled().getLocation();
        location.setPitch((float)rotation.getX());
        location.setYaw((float)rotation.getY());
        this.getHandled().teleport(location);
    }

    @Override
    public Vector3d getHeadRotation() {
        return this.getRotation();
    }

    @Override
    public double getEyeHeight() {
        return this.getHandled().getEyeHeight();
    }

    @Override
    public void setHeadRotation(Vector3d rotation) {
        this.setRotation(rotation);
    }

    @Override
    public void lookAt(Vector3d targetPosition) {
        Vector bukkitEyePos = this.getHandled().getEyeLocation().toVector();
        Vector3d eyePos = new Vector3d(bukkitEyePos.getX(), bukkitEyePos.getY(), bukkitEyePos.getZ());
        if (eyePos == null) {
            return;
        }
        Vector2d xz1 = eyePos.toVector2(true);
        Vector2d xz2 = targetPosition.toVector2(true);
        double distance = xz1.distance(xz2);
        Vector2d p1 = Vector2d.UNIT_Y.mul(eyePos.getY());
        Vector2d p2 = new Vector2d(distance, targetPosition.getY());
        Vector2d v1 = p2.sub(p1);
        Vector2d v2 = Vector2d.UNIT_X.mul(distance);
        double pitchRad = Math.acos(v1.dot(v2) / (v1.length() * v2.length()));
        double pitchDeg = pitchRad * 180.0 / Math.PI * (-v1.getY() / Math.abs(v1.getY()));
        p1 = xz1;
        p2 = xz2;
        v1 = p2.sub(p1);
        v2 = Vector2d.UNIT_Y.mul(v1.getY());
        double yawRad = Math.acos(v1.dot(v2) / (v1.length() * v2.length()));
        double yawDeg = yawRad * 180.0 / Math.PI;
        if (v1.getX() < 0.0 && v1.getY() < 0.0) {
            yawDeg = 180.0 - yawDeg;
        } else if (v1.getX() > 0.0 && v1.getY() < 0.0) {
            yawDeg = 270.0 - (90.0 - yawDeg);
        } else if (v1.getX() > 0.0 && v1.getY() > 0.0) {
            yawDeg = 270.0 + (90.0 - yawDeg);
        }
        this.setRotation(new Vector3d(pitchDeg, yawDeg, this.getRotation().getZ()));
    }

    @Override
    public Optional<WSLivingEntity> getDisguise() {
        return Optional.ofNullable(this.disguise);
    }

    @Override
    public void setDisguise(WSLivingEntity disguise) {
        WSSPacketSpawnMob spawnPacket;
        WSSPacketDestroyEntities removePacket;
        if (this.disguise != null && disguise == null) {
            removePacket = WSSPacketDestroyEntities.of(this.getEntityId());
            spawnPacket = this instanceof WSPlayer ? WSSPacketSpawnPlayer.of((WSPlayer)((Object)this)) : WSSPacketSpawnMob.of(this);
            this.getWorld().getPlayers().forEach(player -> {
                if (player.equals(this)) {
                    return;
                }
                player.sendPacket(removePacket);
                player.sendPacket(spawnPacket);
            });
        }
        if (disguise != null) {
            removePacket = WSSPacketDestroyEntities.of(this.getEntityId());
            spawnPacket = WSSPacketSpawnMob.of(this);
            this.getWorld().getPlayers().forEach(player -> {
                if (player.equals(this)) {
                    return;
                }
                player.sendPacket(removePacket);
                player.sendPacket(spawnPacket);
            });
        }
        this.disguise = disguise;
    }

    @Override
    public boolean hasDisguise() {
        return this.disguise != null;
    }

    @Override
    public void clearDisguise() {
        this.setDisguise(null);
    }

    @Override
    public Optional<WSEntity> getLeashHolder() {
        return Optional.ofNullable(this.getHandled().getLeashHolder()).map(SpigotEntityParser::getWSEntity);
    }

    @Override
    public void setLeashHolder(WSEntity entity) {
        this.getHandled().setLeashHolder(entity == null ? null : ((SpigotEntity)entity).getHandled());
    }

    @Override
    public void addPotionEffect(WSPotionEffect effect) {
        this.getHandled().addPotionEffect(((SpigotPotionEffect)effect).getHandled());
    }

    @Override
    public List<WSPotionEffect> getPotionEffects() {
        return this.getHandled().getActivePotionEffects().stream().map(SpigotPotionEffect::new).collect(Collectors.toList());
    }

    @Override
    public void clearAllPotionEffects() {
        this.getHandled().getActivePotionEffects().forEach(effect -> {
            try {
                this.getHandled().removePotionEffect(effect.getType());
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        });
    }

    @Override
    public void removePotionEffect(EnumPotionEffectType potionEffectType) {
        this.getHandled().removePotionEffect(PotionEffectType.getById((int)potionEffectType.getValue()));
    }

    @Override
    public <T extends WSProjectile> Optional<T> launchProjectile(Class<T> projectile) {
        return this.launchProjectile(projectile, new Vector3d(0.0f, 0.0f, 0.0f));
    }

    @Override
    public <T extends WSProjectile> Optional<T> launchProjectile(Class<T> projectile, Vector3d velocity) {
        EnumEntityType type = EnumEntityType.getByClass(projectile).orElse(EnumEntityType.UNKNOWN);
        if (type == EnumEntityType.UNKNOWN) {
            return Optional.empty();
        }
        try {
            Class<? extends Entity> spigotClass = SpigotEntityParser.getEntityData(type).getEntityClass();
            return Optional.ofNullable(this.getHandled().launchProjectile(spigotClass, new Vector(velocity.getX(), velocity.getY(), velocity.getZ()))).map(entity -> (WSProjectile)SpigotEntityParser.getWSEntity((Entity)entity));
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return Optional.empty();
        }
    }

    public LivingEntity getHandled() {
        return (LivingEntity)super.getHandled();
    }
}

