/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.entity.hanging;

import com.degoos.wetsponge.entity.hanging.SpongeHanging;
import com.degoos.wetsponge.entity.hanging.WSItemFrame;
import com.degoos.wetsponge.enums.EnumRotation;
import com.degoos.wetsponge.item.SpongeItemStack;
import com.degoos.wetsponge.item.WSItemStack;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.hanging.Hanging;
import org.spongepowered.api.entity.hanging.ItemFrame;
import org.spongepowered.api.util.rotation.Rotation;
import org.spongepowered.api.util.rotation.Rotations;

public class SpongeItemFrame
extends SpongeHanging
implements WSItemFrame {
    public SpongeItemFrame(ItemFrame entity) {
        super((Hanging)entity);
    }

    @Override
    public Optional<WSItemStack> getItemStack() {
        Optional snapshot = this.getHandled().get(Keys.REPRESENTED_ITEM);
        return snapshot.flatMap(itemStackSnapshot -> Optional.ofNullable(itemStackSnapshot.createStack()).map(SpongeItemStack::new));
    }

    @Override
    public void setItemStack(WSItemStack itemStack) {
        if (itemStack == null) {
            this.getHandled().offer(Keys.REPRESENTED_ITEM, null);
        } else {
            this.getHandled().offer(Keys.REPRESENTED_ITEM, (Object)((SpongeItemStack)itemStack).getHandled().createSnapshot());
        }
    }

    @Override
    public EnumRotation getFrameRotation() {
        return EnumRotation.getBySpongeName(this.getHandled().get(Keys.ROTATION).orElse(Rotations.TOP).getName()).orElse(EnumRotation.TOP);
    }

    @Override
    public void setRotation(EnumRotation rotation) {
        this.getHandled().offer(Keys.ROTATION, (Object)Sponge.getRegistry().getType(Rotation.class, rotation.getSpongeName()).orElse(Rotations.TOP));
    }

    public ItemFrame getHandled() {
        return (ItemFrame)super.getHandled();
    }
}

