/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.entity.explosive;

import com.degoos.wetsponge.entity.Spigot13Entity;
import com.degoos.wetsponge.entity.explosive.WSPrimedTNT;
import com.degoos.wetsponge.entity.living.WSLivingEntity;
import com.degoos.wetsponge.parser.entity.Spigot13EntityParser;
import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.util.reflection.NMSUtils;
import com.degoos.wetsponge.util.reflection.ReflectionUtils;
import com.degoos.wetsponge.util.reflection.Spigot13HandledUtils;
import java.util.Optional;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.TNTPrimed;

public class Spigot13PrimedTNT
extends Spigot13Entity
implements WSPrimedTNT {
    public Spigot13PrimedTNT(TNTPrimed entity) {
        super((Entity)entity);
    }

    @Override
    public Optional<WSLivingEntity> getDetonator() {
        Entity entity = this.getHandled().getSource();
        if (entity == null || !(entity instanceof LivingEntity)) {
            return Optional.empty();
        }
        return Optional.of((WSLivingEntity)Spigot13EntityParser.getWSEntity(entity));
    }

    @Override
    public void setDetonator(WSLivingEntity entity) {
        try {
            Object handled = Spigot13HandledUtils.getEntityHandle((Entity)this.getHandled());
            ReflectionUtils.setFirstObject(handled.getClass(), NMSUtils.getNMSClass("EntityLiving"), handled, entity == null ? null : Spigot13HandledUtils.getEntityHandle(((Spigot13Entity)((Object)entity)).getHandled()));
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was setting the detonator of a primed TNT!");
        }
    }

    @Override
    public int getFuseDuration() {
        return 100;
    }

    @Override
    public void setFuseDuration(int fuseDuration) {
    }

    @Override
    public int getTicksRemaining() {
        return this.getHandled().getFuseTicks();
    }

    @Override
    public void setTicksRemaining(int ticksRemaining) {
        this.getHandled().setFuseTicks(ticksRemaining);
    }

    @Override
    public boolean isPrimed() {
        return true;
    }

    @Override
    public void prime() {
    }

    @Override
    public void defuse() {
        this.getHandled().remove();
    }

    @Override
    public int setExplosionRadius() {
        return (int)this.getHandled().getYield();
    }

    @Override
    public void setExplosionRadius(int explosionRadius) {
        this.getHandled().setYield((float)explosionRadius);
    }

    @Override
    public void detonate() {
        try {
            ReflectionUtils.invokeMethod(Spigot13HandledUtils.getEntityHandle((Entity)this.getHandled()), "explode", new Object[0]);
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was exploding a primed TNT!");
        }
    }

    public TNTPrimed getHandled() {
        return (TNTPrimed)super.getHandled();
    }
}

