/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.entity;

import com.degoos.wetsponge.entity.WSEntity;
import com.degoos.wetsponge.enums.EnumEntityType;
import com.degoos.wetsponge.nbt.WSNBTTagCompound;
import com.degoos.wetsponge.parser.entity.SpongeEntityParser;
import com.degoos.wetsponge.parser.world.WorldParser;
import com.degoos.wetsponge.text.SpongeText;
import com.degoos.wetsponge.text.WSText;
import com.degoos.wetsponge.text.translation.SpongeTranslation;
import com.degoos.wetsponge.text.translation.WSTranslation;
import com.degoos.wetsponge.util.Validate;
import com.degoos.wetsponge.world.SpongeLocation;
import com.degoos.wetsponge.world.WSLocation;
import com.degoos.wetsponge.world.WSWorld;
import com.flowpowered.math.vector.Vector3d;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class SpongeEntity
implements WSEntity {
    private org.spongepowered.api.entity.Entity entity;
    private EnumEntityType entityType;
    private Map<String, Object> properties;
    private boolean invincible;
    private long invincibleMillis;

    public SpongeEntity(org.spongepowered.api.entity.Entity entity) {
        Validate.notNull(entity, "Entity cannot be null!");
        this.entity = entity;
        this.entityType = SpongeEntityParser.getEntityType(entity);
        this.properties = new HashMap<String, Object>();
    }

    @Override
    public UUID getUniqueId() {
        return this.entity.getUniqueId();
    }

    @Override
    public EnumEntityType getEntityType() {
        return this.entityType;
    }

    @Override
    public boolean isDead() {
        return this.entity.isRemoved();
    }

    @Override
    public boolean isOnGround() {
        return this.entity.isOnGround();
    }

    @Override
    public WSLocation getLocation() {
        return new SpongeLocation((Location<World>)this.entity.getLocation(), this.entity.getRotation());
    }

    @Override
    public void setLocation(WSLocation location) {
        this.entity.setLocationAndRotation(((SpongeLocation)location).getLocation().getLocation(), new Vector3d(location.getPitch(), location.getYaw(), 0.0f));
    }

    @Override
    public WSWorld getWorld() {
        return WorldParser.getOrCreateWorld(this.entity.getWorld().getName(), this.entity.getWorld());
    }

    @Override
    public Vector3d getVelocity() {
        return this.entity.getVelocity();
    }

    @Override
    public void setVelocity(Vector3d velocity) {
        this.entity.setVelocity(velocity);
    }

    @Override
    public Vector3d getRotation() {
        Vector3d vector3d = this.entity.getRotation();
        return new Vector3d(vector3d.getY(), vector3d.getX(), vector3d.getZ());
    }

    @Override
    public void setRotation(Vector3d rotation) {
        this.entity.setRotation(new Vector3d(rotation.getY(), rotation.getX(), rotation.getZ()));
    }

    @Override
    public Optional<WSText> getCustomName() {
        return this.entity.get(Keys.DISPLAY_NAME).map(SpongeText::of);
    }

    @Override
    public void setCustomName(@Nullable WSText customName) {
        this.entity.offer(Keys.DISPLAY_NAME, (Object)((SpongeText)customName).getHandled());
    }

    @Override
    public boolean isCustomNameVisible() {
        return this.entity.get(Keys.CUSTOM_NAME_VISIBLE).orElse(false);
    }

    @Override
    public void setCustomNameVisible(boolean customNameVisible) {
        this.entity.offer(Keys.CUSTOM_NAME_VISIBLE, (Object)customNameVisible);
    }

    @Override
    public Set<WSEntity> getPassengers() {
        return this.entity.getPassengers().stream().map(SpongeEntityParser::getWSEntity).collect(Collectors.toSet());
    }

    @Override
    public boolean addPassenger(WSEntity entity) {
        return this.entity.addPassenger(((SpongeEntity)entity).entity);
    }

    @Override
    public Optional<WSEntity> getRidingEntity() {
        return Optional.ofNullable(((Entity)this.entity).func_184187_bx()).map(target -> SpongeEntityParser.getWSEntity((org.spongepowered.api.entity.Entity)target));
    }

    @Override
    public void mountEntity(WSEntity entity) {
        ((Entity)this.entity).func_184220_m((Entity)((SpongeEntity)entity).entity);
    }

    @Override
    public void dismountRidingEntity() {
        ((Entity)this.entity).func_184210_p();
    }

    @Override
    public boolean isRiding() {
        return ((Entity)this.entity).func_184218_aH();
    }

    @Override
    public boolean isBeingRidden() {
        return ((Entity)this.entity).func_184207_aI();
    }

    @Override
    public int getEntityId() {
        return ((Entity)this.entity).func_145782_y();
    }

    @Override
    public void addProperty(String id, Object value) {
        this.properties.putIfAbsent(id, value);
    }

    @Override
    public void addProperty(String id, Object value, boolean force) {
        if (force) {
            this.properties.put(id, value);
        } else {
            this.properties.putIfAbsent(id, value);
        }
    }

    @Override
    public Optional<Object> getProperty(String id) {
        return Optional.ofNullable(this.properties.get(id));
    }

    @Override
    public <T> Optional<T> getProperty(String id, Class<T> expected) {
        Optional<Object> optional = Optional.ofNullable(this.properties.get(id));
        if (!optional.isPresent() || !expected.isInstance(optional.get())) {
            return Optional.empty();
        }
        return optional.map(o -> o);
    }

    @Override
    public void removeProperty(String id) {
        this.properties.remove(id);
    }

    @Override
    public Map<String, Object> getProperties() {
        return new HashMap<String, Object>(this.properties);
    }

    @Override
    public boolean hasGravity() {
        return (Boolean)this.entity.gravity().get();
    }

    @Override
    public void setGravity(boolean gravity) {
        this.entity.offer(Keys.HAS_GRAVITY, (Object)gravity);
    }

    @Override
    public boolean isGlowing() {
        return this.entity.get(Keys.GLOWING).orElse(false);
    }

    @Override
    public void setGlowing(boolean glowing) {
        this.entity.offer(Keys.GLOWING, (Object)glowing);
    }

    @Override
    public boolean isSilent() {
        return this.entity.get(Keys.IS_SILENT).orElse(false);
    }

    @Override
    public void setSilent(boolean silent) {
        this.entity.offer(Keys.IS_SILENT, (Object)silent);
    }

    @Override
    public boolean isInvisible() {
        return this.entity.get(Keys.INVISIBLE).orElse(false);
    }

    @Override
    public void setInvisible(boolean invisible) {
        this.entity.offer(Keys.INVISIBLE, (Object)invisible);
    }

    @Override
    public boolean isInvincible() {
        return this.invincible || this.invincibleMillis > System.currentTimeMillis();
    }

    @Override
    public void setInvincible(boolean invincible) {
        this.invincibleMillis = 0L;
        this.invincible = invincible;
    }

    @Override
    public void setInvincibleMillis(int millis) {
        this.invincibleMillis = System.currentTimeMillis() + (long)millis;
        this.invincible = false;
    }

    @Override
    public int getAir() {
        return this.entity.get(Keys.REMAINING_AIR).orElse(0);
    }

    @Override
    public void setAir(int air) {
        this.entity.offer(Keys.REMAINING_AIR, (Object)air);
    }

    @Override
    public int getFireTicks() {
        return this.entity.get(Keys.FIRE_TICKS).orElse(0);
    }

    @Override
    public void setFireTicks(int fireTicks) {
        this.entity.offer(Keys.FIRE_TICKS, (Object)fireTicks);
    }

    @Override
    public int getMaxFireTicks() {
        try {
            Method method = Entity.class.getMethod("getFireImmuneTicks", new Class[0]);
            method.setAccessible(true);
            return (Integer)method.invoke((Object)this.entity, new Object[0]);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public float getFallDistance() {
        return this.entity.get(Keys.FALL_DISTANCE).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public void setFallDistance(float fallDistance) {
        this.entity.offer(Keys.FALL_DISTANCE, (Object)Float.valueOf(fallDistance));
    }

    @Override
    public Vector3d getEntitySize() {
        Entity mEntity = (Entity)this.entity;
        return new Vector3d(mEntity.field_70130_N, mEntity.field_70131_O, mEntity.field_70130_N);
    }

    @Override
    public WSNBTTagCompound writeToNBTTagCompound(WSNBTTagCompound nbtTagCompound) {
        ((Entity)this.entity).func_189511_e((NBTTagCompound)nbtTagCompound.getHandled());
        return nbtTagCompound;
    }

    @Override
    public WSNBTTagCompound writeToNBTTagCompoundAtomically(WSNBTTagCompound nbtTagCompound) {
        ((Entity)this.entity).func_184198_c((NBTTagCompound)nbtTagCompound.getHandled());
        return nbtTagCompound;
    }

    @Override
    public WSNBTTagCompound writeToNBTTagCompoundOptional(WSNBTTagCompound nbtTagCompound) {
        ((Entity)this.entity).func_70039_c((NBTTagCompound)nbtTagCompound.getHandled());
        return nbtTagCompound;
    }

    @Override
    public WSNBTTagCompound readFromNBTTagCompound(WSNBTTagCompound nbtTagCompound) {
        ((Entity)this.entity).func_70020_e((NBTTagCompound)nbtTagCompound.getHandled());
        return nbtTagCompound;
    }

    @Override
    public void remove() {
        this.entity.remove();
    }

    public org.spongepowered.api.entity.Entity getHandled() {
        return this.entity;
    }

    @Override
    public WSTranslation getTranslation() {
        return new SpongeTranslation(this.entity.getTranslation());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeEntity that = (SpongeEntity)o;
        return this.entity.equals(that.entity);
    }

    public int hashCode() {
        return this.entity.hashCode();
    }
}

