/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.config;

import com.degoos.wetsponge.config.ConfigSection;
import com.degoos.wetsponge.enums.EnumConfigType;
import com.degoos.wetsponge.util.Validate;
import com.google.common.base.Charsets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.nodes.Tag;

public class ConfigAccessor {
    private Yaml yaml;
    private File file;
    private InputStream inputStream;
    private OutputStream outputStream;
    private Reader reader;
    private Writer writer;
    private Map<String, Object> data;
    private EnumConfigType configType;

    public ConfigAccessor(File file) {
        Validate.notNull(file, "File cannot be null!");
        this.file = file;
        this.configType = EnumConfigType.FILE;
        this.loadFile(file);
        if (this.data == null) {
            this.data = new HashMap<String, Object>();
        }
    }

    public ConfigAccessor(InputStream inputStream) {
        this(inputStream, null);
    }

    public ConfigAccessor(InputStream inputStream, OutputStream outputStream) {
        Validate.notNull(inputStream, "InputStream cannot be null!");
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        this.configType = EnumConfigType.INPUT_STREAM;
        this.loadInputStream(inputStream);
        if (this.data == null) {
            this.data = new HashMap<String, Object>();
        }
    }

    public ConfigAccessor(Reader reader) {
        this(reader, null);
    }

    public ConfigAccessor(Reader reader, Writer writer) {
        Validate.notNull(reader, "Reader cannot be null!");
        this.reader = reader;
        this.writer = writer;
        this.configType = EnumConfigType.READER;
        this.loadReader(reader);
        if (this.data == null) {
            this.data = new HashMap<String, Object>();
        }
    }

    private void loadFile(File file) {
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            if (file.isDirectory()) {
                file.delete();
                file.createNewFile();
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return;
        }
        this.yaml = new Yaml();
        try {
            this.data = (Map)this.yaml.load(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void loadInputStream(InputStream inputStream) {
        this.yaml = new Yaml();
        this.data = (Map)this.yaml.load(inputStream);
        try {
            inputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadReader(Reader reader) {
        this.yaml = new Yaml();
        this.data = (Map)this.yaml.load(reader);
    }

    public Yaml getYaml() {
        return this.yaml;
    }

    public EnumConfigType getConfigType() {
        return this.configType;
    }

    public File getFile() {
        return this.file;
    }

    public InputStream getInputStream() {
        return null;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public Reader getReader() {
        return this.reader;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void save() {
        switch (this.configType) {
            case FILE: {
                this.save(this.file);
                break;
            }
            case INPUT_STREAM: {
                this.save(this.outputStream);
                break;
            }
            case READER: {
                this.save(this.writer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file) {
        Writer writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charsets.UTF_8);
            String string = this.yaml.dumpAs(this.data, Tag.YAML, DumperOptions.FlowStyle.BLOCK);
            writer.write(string.replaceFirst("!!yaml\n", ""));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(OutputStream stream) {
        if (this.outputStream == null) {
            return;
        }
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter(this.outputStream, Charsets.UTF_8);
            String string = this.yaml.dumpAs(this.data, Tag.YAML, DumperOptions.FlowStyle.BLOCK);
            writer.write(string.replaceFirst("!!yaml\n", ""));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    ((Writer)writer).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void save(Writer writer) {
        if (writer == null) {
            return;
        }
        try {
            String string = this.yaml.dumpAs(this.data, Tag.YAML, DumperOptions.FlowStyle.BLOCK);
            writer.write(string.replaceFirst("!!yaml\n", ""));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void reload() {
        switch (this.configType) {
            case FILE: {
                this.loadFile(this.file);
                break;
            }
            case INPUT_STREAM: {
                try {
                    this.inputStream.reset();
                    this.loadInputStream(this.inputStream);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
            case READER: {
                this.loadReader(this.reader);
                break;
            }
        }
    }

    public void set(String node, Object value) {
        String[] array = node.replace(".", ";").split(";");
        HashMap<String, Object> section = this.data;
        for (int i = 0; i < array.length - 1; ++i) {
            if (!section.containsKey(array[i]) || !(section.get(array[i]) instanceof Map)) {
                if (value == null) {
                    return;
                }
                HashMap<String, Object> newMap = new HashMap<String, Object>();
                section.put(array[i], newMap);
                section = newMap;
                continue;
            }
            section = (HashMap<String, Object>)section.get(array[i]);
        }
        if (value == null) {
            section.remove(array[array.length - 1]);
            StringBuilder builder = new StringBuilder();
            for (int n = 0; n < array.length - 1; ++n) {
                builder.append(".").append(array[n]);
            }
            String mapNode = builder.toString().replaceFirst(".", "");
            Map map = (Map)this.get(mapNode);
            if (map != null && map.isEmpty()) {
                this.set(mapNode, null);
            }
        } else {
            section.put(array[array.length - 1], value);
        }
    }

    public Object get(String node) {
        String[] array = node.replace(".", ";").split(";");
        Map section = this.data;
        for (int i = 0; i < array.length - 1; ++i) {
            if (!section.containsKey(array[i])) {
                return null;
            }
            Object object = section.get(array[i]);
            if (!(object instanceof Map)) {
                return null;
            }
            section = (Map)object;
        }
        return section.getOrDefault(array[array.length - 1], null);
    }

    public String getString(String node) {
        Object object = this.get(node);
        return object != null && object instanceof String ? (String)object : "";
    }

    public String getString(String node, String def) {
        Object object = this.get(node);
        return object != null && object instanceof String ? (String)object : def;
    }

    public byte getByte(String node) {
        Object object = this.get(node);
        return object != null && object instanceof Byte ? (Byte)object : (byte)0;
    }

    public byte getByte(String node, byte def) {
        Object object = this.get(node);
        return object != null && object instanceof Byte ? (Byte)object : def;
    }

    public short getShort(String node) {
        Object object = this.get(node);
        return object != null && object instanceof Short ? (Short)object : (short)0;
    }

    public short getShort(String node, short def) {
        Object object = this.get(node);
        return object != null && object instanceof Short ? (Short)object : def;
    }

    public int getInt(String node) {
        Object object = this.get(node);
        return object != null && object instanceof Integer ? (Integer)object : 0;
    }

    public int getInt(String node, int def) {
        Object object = this.get(node);
        return object != null && object instanceof Integer ? (Integer)object : def;
    }

    public long getLong(String node) {
        Object object = this.get(node);
        return object != null && object instanceof Long ? (Long)object : 0L;
    }

    public long getLong(String node, long def) {
        Object object = this.get(node);
        return object != null && object instanceof Long ? (Long)object : def;
    }

    public float getFloat(String node) {
        Object object = this.get(node);
        return object != null && object instanceof Float ? ((Float)object).floatValue() : 0.0f;
    }

    public float getFloat(String node, float def) {
        Object object = this.get(node);
        return object != null && object instanceof Float ? ((Float)object).floatValue() : def;
    }

    public double getDouble(String node) {
        Object object = this.get(node);
        return object != null && object instanceof Double ? (Double)object : 0.0;
    }

    public double getDouble(String node, double def) {
        Object object = this.get(node);
        return object != null && object instanceof Double ? (Double)object : def;
    }

    public boolean getBoolean(String node) {
        Object object = this.get(node);
        return object != null && object instanceof Boolean ? (Boolean)object : false;
    }

    public boolean getBoolean(String node, boolean def) {
        Object object = this.get(node);
        return object != null && object instanceof Boolean ? (Boolean)object : def;
    }

    public List<?> getList(String node) {
        Object val = this.get(node);
        return val != null && val instanceof List ? (List)val : null;
    }

    public List<?> getList(String node, List<?> def) {
        List<?> val = this.get(node);
        return val instanceof List ? val : def;
    }

    public List<String> getStringList(String path) {
        List<?> list = this.getList(path);
        if (list == null) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> result = new ArrayList<String>();
        Iterator<?> var4 = list.iterator();
        while (var4.hasNext()) {
            Object object = var4.next();
            if (!(object instanceof String) && !this.isPrimitiveWrapper(object)) continue;
            result.add(String.valueOf(object));
        }
        return result;
    }

    public List<String> getStringList(String node, List<String> def) {
        List<String> list = this.getStringList(node);
        return list == null || list.isEmpty() ? def : list;
    }

    private boolean isPrimitiveWrapper(Object input) {
        return input instanceof Integer || input instanceof Boolean || input instanceof Character || input instanceof Byte || input instanceof Short || input instanceof Double || input instanceof Long || input instanceof Float;
    }

    public Set<String> getKeys() {
        return this.getKeys(this.data);
    }

    public Set<String> getKeys(boolean deep) {
        if (deep) {
            return this.getKeys();
        }
        return this.getKeys(this.data).stream().map(string -> string.replace(".", "/").split("/")[0]).collect(Collectors.toSet());
    }

    private Set<String> getKeys(Map<String, Object> map) {
        HashSet<String> strings = new HashSet<String>();
        map.forEach((key, value) -> {
            if (value instanceof Map) {
                strings.addAll(this.getKeys((Map)value).stream().map(string -> key + "." + string).collect(Collectors.toList()));
            } else {
                strings.add((String)key);
            }
        });
        return strings;
    }

    public void checkNodes(ConfigAccessor master, boolean save) {
        master.getKeys(true).stream().filter(node -> !this.contains((String)node)).forEach(node -> this.set((String)node, master.get((String)node)));
        this.getKeys(true).stream().filter(node -> !master.contains((String)node)).forEach(node -> this.set((String)node, null));
        if (save) {
            this.save();
        }
    }

    public boolean contains(String node) {
        return this.get(node) != null;
    }

    public ConfigSection getSection(String node) {
        return new ConfigSection(this, node);
    }
}

