/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.command;

import com.degoos.wetsponge.command.WSCommand;
import com.degoos.wetsponge.plugin.WSPlugin;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class WSCommandManager {
    private static WSCommandManager ourInstance = new WSCommandManager();
    private Map<String, WSCommand> commands = new HashMap<String, WSCommand>();

    private WSCommandManager() {
    }

    public static WSCommandManager getInstance() {
        return ourInstance;
    }

    public boolean addCommand(WSCommand command) {
        String name = command.getName().toLowerCase();
        if (this.commands.containsKey(name)) {
            return false;
        }
        this.commands.put(name, command);
        return true;
    }

    public boolean addCommand(WSPlugin plugin, WSCommand command) {
        String name = command.getName().toLowerCase();
        if (this.commands.containsKey(name)) {
            return false;
        }
        this.commands.put(name, command);
        return true;
    }

    public Optional<WSCommand> getCommand(String name) {
        WSCommand command = this.commands.get(name.toLowerCase());
        if (command == null) {
            return this.commands.values().stream().filter(target -> target.hasAlias(name)).findAny();
        }
        return Optional.of(command);
    }

    public Set<WSCommand> getCommands() {
        return new HashSet<WSCommand>(this.commands.values());
    }

    public boolean removeCommand(String name) {
        if (!this.commands.containsKey(name.toLowerCase())) {
            return false;
        }
        this.commands.remove(name.toLowerCase());
        return true;
    }

    public Set<String> getCommandsAndAliases() {
        Set<String> set = this.commands.values().stream().map(WSCommand::getName).collect(Collectors.toSet());
        this.commands.values().forEach(command -> set.addAll(command.getAliases()));
        return set;
    }
}

