/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.command;

import com.degoos.wetsponge.command.WSCommandSource;
import com.degoos.wetsponge.util.Validate;
import java.util.Arrays;
import java.util.List;

public abstract class WSCommand {
    private String name;
    private String description;
    private List<String> aliases;

    public WSCommand(String name, String description, String ... aliases) {
        Validate.notNull(name, "Name cannot be null!");
        Validate.notNull(description, "Description cannot be null!");
        this.name = name;
        this.description = description;
        this.aliases = Arrays.asList(aliases);
    }

    public abstract void executeCommand(WSCommandSource var1, String var2, String[] var3);

    public abstract List<String> sendTab(WSCommandSource var1, String var2, String[] var3);

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public void addAlias(String alias) {
        this.aliases.add(alias);
    }

    public void removeAlias(String alias) {
        this.aliases.remove(alias);
    }

    public boolean hasAlias(String alias) {
        return this.aliases.stream().anyMatch(target -> target.equalsIgnoreCase(alias));
    }

    public void setDescription(String description) {
        Validate.notNull(description, "Description cannot be null!");
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WSCommand wsCommand = (WSCommand)o;
        return this.name.equals(wsCommand.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

