/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.bridge.packet;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.enums.EnumEntityAction;
import com.degoos.wetsponge.enums.EnumServerVersion;
import com.degoos.wetsponge.packet.play.client.Spigot13CPacketCloseWindows;
import com.degoos.wetsponge.packet.play.client.Spigot13CPacketEntityAction;
import com.degoos.wetsponge.packet.play.client.Spigot13CPacketUpdateSign;
import com.degoos.wetsponge.packet.play.client.SpigotCPacketCloseWindows;
import com.degoos.wetsponge.packet.play.client.SpigotCPacketEntityAction;
import com.degoos.wetsponge.packet.play.client.SpigotCPacketUpdateSign;
import com.degoos.wetsponge.packet.play.client.SpongeCPacketCloseWindows;
import com.degoos.wetsponge.packet.play.client.SpongeCPacketEntityAction;
import com.degoos.wetsponge.packet.play.client.SpongeCPacketUpdateSign;
import com.degoos.wetsponge.packet.play.client.WSCPacketCloseWindows;
import com.degoos.wetsponge.packet.play.client.WSCPacketEntityAction;
import com.degoos.wetsponge.packet.play.client.WSCPacketUpdateSign;
import com.flowpowered.math.vector.Vector3d;

public class BridgeClientPacket {
    public static WSCPacketCloseWindows newWSCPacketCloseWindows(int windowsId) {
        switch (WetSponge.getServerType()) {
            case SPIGOT: 
            case PAPER_SPIGOT: {
                try {
                    if (WetSponge.getVersion().isOlderThan(EnumServerVersion.MINECRAFT_1_13)) {
                        return new SpigotCPacketCloseWindows(windowsId);
                    }
                    return new Spigot13CPacketCloseWindows(windowsId);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            case SPONGE: {
                return new SpongeCPacketCloseWindows(windowsId);
            }
        }
        return null;
    }

    public static WSCPacketEntityAction newWSCPacketEntityAction(int entityId, EnumEntityAction entityAction, int jumpBoost) {
        switch (WetSponge.getServerType()) {
            case SPIGOT: 
            case PAPER_SPIGOT: {
                try {
                    if (WetSponge.getVersion().isOlderThan(EnumServerVersion.MINECRAFT_1_13)) {
                        return new SpigotCPacketEntityAction(entityId, entityAction, jumpBoost);
                    }
                    return new Spigot13CPacketEntityAction(entityId, entityAction, jumpBoost);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            case SPONGE: {
                return new SpongeCPacketEntityAction(entityId, entityAction, jumpBoost);
            }
        }
        return null;
    }

    public static WSCPacketUpdateSign newWSCPacketUpdateSign(Vector3d position, String[] lines) {
        switch (WetSponge.getServerType()) {
            case SPIGOT: 
            case PAPER_SPIGOT: {
                try {
                    if (WetSponge.getVersion().isOlderThan(EnumServerVersion.MINECRAFT_1_13)) {
                        return new SpigotCPacketUpdateSign(position, lines);
                    }
                    return new Spigot13CPacketUpdateSign(position, lines);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            case SPONGE: {
                return new SpongeCPacketUpdateSign(position, lines);
            }
        }
        return null;
    }
}

