/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.block.tileentity;

import com.degoos.wetsponge.block.SpongeBlock;
import com.degoos.wetsponge.block.tileentity.SpongeTileEntity;
import com.degoos.wetsponge.block.tileentity.WSTileEntitySkull;
import com.degoos.wetsponge.enums.block.EnumBlockFace;
import com.degoos.wetsponge.enums.block.EnumBlockTypeSkullType;
import com.degoos.wetsponge.resource.sponge.SpongeSkullBuilder;
import com.degoos.wetsponge.user.SpongeGameProfile;
import com.degoos.wetsponge.user.WSGameProfile;
import java.net.URL;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.tileentity.Skull;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.SkullType;
import org.spongepowered.api.data.type.SkullTypes;
import org.spongepowered.api.util.Direction;

public class SpongeTileEntitySkull
extends SpongeTileEntity
implements WSTileEntitySkull {
    public SpongeTileEntitySkull(SpongeBlock block) {
        super(block);
    }

    @Override
    public WSGameProfile getGameProfile() {
        return new SpongeGameProfile(this.getHandled().getBlock().get(Keys.REPRESENTED_PLAYER).orElse(null));
    }

    @Override
    public void setGameProfile(WSGameProfile gameProfile) {
        BlockState state = this.getHandled().getBlock();
        this.getHandled().getLocation().setBlock(state.with(Keys.REPRESENTED_PLAYER, (Object)((SpongeGameProfile)gameProfile).getHandled()).orElse(state));
    }

    @Override
    public EnumBlockFace getOrientation() {
        return EnumBlockFace.getBySpongeName(this.getHandled().get(Keys.DIRECTION).orElse(Direction.DOWN).name()).orElse(EnumBlockFace.SOUTH);
    }

    @Override
    public void setOrientation(EnumBlockFace orientation) {
        this.getHandled().offer(Keys.DIRECTION, (Object)Direction.valueOf((String)orientation.getSpongeName()));
    }

    @Override
    public EnumBlockTypeSkullType getSkullType() {
        return EnumBlockTypeSkullType.getBySpongeName(((SkullType)this.getHandled().skullType().get()).getName()).orElse(EnumBlockTypeSkullType.SKELETON);
    }

    @Override
    public void setSkullType(EnumBlockTypeSkullType skullType) {
        this.getHandled().offer(Keys.SKULL_TYPE, (Object)Sponge.getRegistry().getType(SkullType.class, skullType.getSpongeName()).orElse(SkullTypes.SKELETON));
    }

    @Override
    public void setTexture(String texture) {
        this.getHandled().getLocation().setBlock(SpongeSkullBuilder.updateSkullByTexture(this.getHandled().getBlock(), texture));
    }

    @Override
    public void setTexture(URL texture) {
        this.getHandled().getLocation().setBlock(SpongeSkullBuilder.updateSkullByURL(this.getHandled().getBlock(), texture));
    }

    @Override
    public void setTextureByPlayerName(String name) {
        this.getHandled().getLocation().setBlock(SpongeSkullBuilder.updateSkullByPlayerName(this.getHandled().getBlock(), name));
    }

    @Override
    public void findFormatAndSetTexture(String texture) {
        this.getHandled().getLocation().setBlock(SpongeSkullBuilder.updateSkullByUnknownFormat(this.getHandled().getBlock(), texture));
    }

    public Skull getHandled() {
        return (Skull)super.getHandled();
    }
}

