/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.block.tileentity;

import com.degoos.wetsponge.block.Spigot13Block;
import com.degoos.wetsponge.block.tileentity.Spigot13TileEntity;
import com.degoos.wetsponge.block.tileentity.WSTileEntitySkull;
import com.degoos.wetsponge.enums.block.EnumBlockFace;
import com.degoos.wetsponge.enums.block.EnumBlockTypeSkullType;
import com.degoos.wetsponge.resource.spigot.Spigot13SkullBuilder;
import com.degoos.wetsponge.user.Spigot13GameProfile;
import com.degoos.wetsponge.user.WSGameProfile;
import com.mojang.authlib.GameProfile;
import java.net.URL;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.SkullType;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Skull;

public class Spigot13TileEntitySkull
extends Spigot13TileEntity
implements WSTileEntitySkull {
    public Spigot13TileEntitySkull(Spigot13Block block) {
        super(block);
    }

    @Override
    public WSGameProfile getGameProfile() {
        Skull skull = this.getHandled();
        return WSGameProfile.of(skull.getOwningPlayer().getUniqueId(), skull.getOwningPlayer().getName());
    }

    @Override
    public void setGameProfile(WSGameProfile gameProfile) {
        GameProfile handledProfile = ((Spigot13GameProfile)gameProfile).getHandled();
        this.getHandled().setOwningPlayer(Bukkit.getOfflinePlayer((UUID)handledProfile.getId()));
        Spigot13SkullBuilder.injectGameProfile(this.getHandled(), ((Spigot13GameProfile)gameProfile).getHandled());
        this.update();
    }

    @Override
    public EnumBlockFace getOrientation() {
        return EnumBlockFace.valueOf(this.getHandled().getRotation().name());
    }

    @Override
    public void setOrientation(EnumBlockFace orientation) {
        this.getHandled().setRotation(BlockFace.valueOf((String)orientation.name()));
        this.update();
    }

    @Override
    public EnumBlockTypeSkullType getSkullType() {
        return EnumBlockTypeSkullType.getBySpigotName(this.getHandled().getSkullType().name()).orElse(EnumBlockTypeSkullType.SKELETON);
    }

    @Override
    public void setSkullType(EnumBlockTypeSkullType skullType) {
        this.getHandled().setSkullType(SkullType.valueOf((String)skullType.getSpigotName()));
        this.update();
    }

    @Override
    public void setTexture(String texture) {
        Spigot13SkullBuilder.updateSkullByTexture(this.getHandled(), texture);
        this.update();
    }

    @Override
    public void setTexture(URL texture) {
        Spigot13SkullBuilder.updateSkullByURL(this.getHandled(), texture);
        this.update();
    }

    @Override
    public void setTextureByPlayerName(String name) {
        Spigot13SkullBuilder.updateSkullByPlayerName(this.getHandled(), name);
        this.update();
    }

    @Override
    public void findFormatAndSetTexture(String texture) {
        Spigot13SkullBuilder.updateSkullByUnknownFormat(this.getHandled(), texture);
        this.update();
    }

    public Skull getHandled() {
        return (Skull)super.getHandled();
    }
}

