/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.block;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.block.SpongeBlockState;
import com.degoos.wetsponge.block.WSBlock;
import com.degoos.wetsponge.block.WSBlockState;
import com.degoos.wetsponge.block.tileentity.SpongeTileEntity;
import com.degoos.wetsponge.block.tileentity.SpongeTileEntityBrewingStand;
import com.degoos.wetsponge.block.tileentity.SpongeTileEntityChest;
import com.degoos.wetsponge.block.tileentity.SpongeTileEntityCommandBlock;
import com.degoos.wetsponge.block.tileentity.SpongeTileEntityDispenser;
import com.degoos.wetsponge.block.tileentity.SpongeTileEntityFurnace;
import com.degoos.wetsponge.block.tileentity.SpongeTileEntityJukebox;
import com.degoos.wetsponge.block.tileentity.SpongeTileEntityMonsterSpawner;
import com.degoos.wetsponge.block.tileentity.SpongeTileEntityNameable;
import com.degoos.wetsponge.block.tileentity.SpongeTileEntityNameableInventory;
import com.degoos.wetsponge.block.tileentity.SpongeTileEntityNoteblock;
import com.degoos.wetsponge.block.tileentity.SpongeTileEntitySign;
import com.degoos.wetsponge.block.tileentity.SpongeTileEntitySkull;
import com.degoos.wetsponge.enums.EnumMapBaseColor;
import com.degoos.wetsponge.enums.EnumServerVersion;
import com.degoos.wetsponge.enums.block.EnumBlockFace;
import com.degoos.wetsponge.material.SpongeMaterial;
import com.degoos.wetsponge.material.WSBlockTypes;
import com.degoos.wetsponge.material.block.WSBlockType;
import com.degoos.wetsponge.parser.world.WorldParser;
import com.degoos.wetsponge.world.SpongeLocation;
import com.degoos.wetsponge.world.WSLocation;
import com.degoos.wetsponge.world.WSWorld;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.world.Location;

public class SpongeBlock
implements WSBlock {
    private Location<org.spongepowered.api.world.World> location;

    public SpongeBlock(Location<org.spongepowered.api.world.World> location) {
        this.location = location;
    }

    @Override
    public WSLocation getLocation() {
        return new SpongeLocation(this.location);
    }

    @Override
    public WSWorld getWorld() {
        return WorldParser.getOrCreateWorld(((org.spongepowered.api.world.World)this.location.getExtent()).getName(), this.location.getExtent());
    }

    @Override
    public int getNumericalId() {
        return this.getBlockType().getNumericalId();
    }

    @Override
    public String getStringId() {
        return WetSponge.getVersion().isOlderThan(EnumServerVersion.MINECRAFT_1_13) ? this.getOldStringId() : this.getNewStringId();
    }

    @Override
    public String getNewStringId() {
        return !WetSponge.getVersion().isOlderThan(EnumServerVersion.MINECRAFT_1_13) ? this.location.getBlock().getType().getId() : this.getBlockType().getNewStringId();
    }

    @Override
    public String getOldStringId() {
        return WetSponge.getVersion().isOlderThan(EnumServerVersion.MINECRAFT_1_13) ? this.location.getBlock().getType().getId() : this.getBlockType().getOldStringId();
    }

    @Override
    public WSBlockState createState() {
        return new SpongeBlockState(this);
    }

    @Override
    public SpongeTileEntity getTileEntity() {
        switch (this.getNumericalId()) {
            case 23: {
                return new SpongeTileEntityDispenser(this);
            }
            case 25: {
                return new SpongeTileEntityNoteblock(this);
            }
            case 52: {
                return new SpongeTileEntityMonsterSpawner(this);
            }
            case 54: 
            case 146: {
                return new SpongeTileEntityChest(this);
            }
            case 61: 
            case 62: {
                return new SpongeTileEntityFurnace(this);
            }
            case 63: 
            case 68: {
                return new SpongeTileEntitySign(this);
            }
            case 84: {
                return new SpongeTileEntityJukebox(this);
            }
            case 116: {
                return new SpongeTileEntityNameable(this);
            }
            case 117: {
                return new SpongeTileEntityBrewingStand(this);
            }
            case 137: {
                return new SpongeTileEntityCommandBlock(this);
            }
            case 144: {
                return new SpongeTileEntitySkull(this);
            }
            case 154: {
                return new SpongeTileEntityNameableInventory(this);
            }
        }
        return new SpongeTileEntity(this);
    }

    @Override
    public WSBlockType getBlockType() {
        WSBlockType type = WSBlockTypes.getById(this.getStringId()).orElse(WSBlockTypes.AIR.getDefaultState());
        ((SpongeMaterial)((Object)type)).readContainer((ValueContainer<?>)this.getHandled().getBlock());
        return type;
    }

    @Override
    public WSBlock getRelative(EnumBlockFace direction) {
        return this.getLocation().add(direction.getRelative().toDouble()).getBlock();
    }

    @Override
    public EnumMapBaseColor getMapBaseColor() {
        BlockPos pos = new BlockPos(this.location.getX(), this.location.getY(), this.location.getZ());
        return EnumMapBaseColor.getById(((World)this.location.getExtent()).func_180495_p((BlockPos)pos).func_185909_g((IBlockAccess)((World)this.getWorld().getHandled()), (BlockPos)pos).field_76290_q).orElse(EnumMapBaseColor.AIR);
    }

    public Location<org.spongepowered.api.world.World> getHandled() {
        return this.location;
    }
}

