/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.block;

import com.degoos.wetsponge.block.Spigot13Block;
import com.degoos.wetsponge.block.WSBlock;
import com.degoos.wetsponge.block.WSBlockState;
import com.degoos.wetsponge.material.WSBlockTypes;
import com.degoos.wetsponge.material.block.Spigot13BlockType;
import com.degoos.wetsponge.material.block.WSBlockType;
import com.degoos.wetsponge.world.WSLocation;
import com.degoos.wetsponge.world.WSWorld;
import org.bukkit.block.Block;

public class Spigot13BlockState
implements WSBlockState {
    private WSLocation location;
    private WSBlockType blockType;
    private Spigot13Block block;

    public Spigot13BlockState(Spigot13Block block) {
        this.location = block.getLocation();
        this.block = block;
        this.refresh();
    }

    @Override
    public WSLocation getLocation() {
        return this.location;
    }

    @Override
    public WSWorld getWorld() {
        return this.location.getWorld();
    }

    @Override
    public WSBlock getBlock() {
        return this.block;
    }

    @Override
    public WSBlockType getBlockType() {
        return this.blockType;
    }

    @Override
    public Spigot13BlockState setBlockType(WSBlockType blockType) {
        this.blockType = blockType;
        return this;
    }

    @Override
    public void update() {
        this.update(true);
    }

    @Override
    public void update(boolean applyPhysics) {
        Block spigotBlock = this.block.getHandled();
        spigotBlock.setBlockData(((Spigot13BlockType)this.blockType).toBlockData());
        spigotBlock.getState().update(true, applyPhysics);
    }

    @Override
    public void refresh() {
        this.blockType = WSBlockTypes.getById(this.block.getNewStringId()).orElse(null);
        if (this.blockType == null) {
            this.blockType = new Spigot13BlockType(-1, this.block.getNewStringId(), this.block.getNewStringId(), this.block.getHandled().getType().getMaxStackSize());
        }
        ((Spigot13BlockType)this.blockType).readBlockData(this.block.getHandled().getBlockData());
    }
}

