/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.block;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.block.Spigot13BlockState;
import com.degoos.wetsponge.block.WSBlock;
import com.degoos.wetsponge.block.WSBlockState;
import com.degoos.wetsponge.block.tileentity.Spigot13TileEntity;
import com.degoos.wetsponge.block.tileentity.Spigot13TileEntityBrewingStand;
import com.degoos.wetsponge.block.tileentity.Spigot13TileEntityChest;
import com.degoos.wetsponge.block.tileentity.Spigot13TileEntityCommandBlock;
import com.degoos.wetsponge.block.tileentity.Spigot13TileEntityDispenser;
import com.degoos.wetsponge.block.tileentity.Spigot13TileEntityFurnace;
import com.degoos.wetsponge.block.tileentity.Spigot13TileEntityJukebox;
import com.degoos.wetsponge.block.tileentity.Spigot13TileEntityMonsterSpawner;
import com.degoos.wetsponge.block.tileentity.Spigot13TileEntityNameable;
import com.degoos.wetsponge.block.tileentity.Spigot13TileEntityNameableInventory;
import com.degoos.wetsponge.block.tileentity.Spigot13TileEntityNoteblock;
import com.degoos.wetsponge.block.tileentity.Spigot13TileEntitySign;
import com.degoos.wetsponge.block.tileentity.Spigot13TileEntitySkull;
import com.degoos.wetsponge.enums.EnumMapBaseColor;
import com.degoos.wetsponge.enums.EnumServerVersion;
import com.degoos.wetsponge.enums.block.EnumBlockFace;
import com.degoos.wetsponge.material.WSBlockTypes;
import com.degoos.wetsponge.material.WSMaterial;
import com.degoos.wetsponge.material.block.Spigot13BlockType;
import com.degoos.wetsponge.material.block.WSBlockType;
import com.degoos.wetsponge.parser.world.WorldParser;
import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.util.reflection.ReflectionUtils;
import com.degoos.wetsponge.util.reflection.Spigot13HandledUtils;
import com.degoos.wetsponge.util.reflection.Spigot13MapUtils;
import com.degoos.wetsponge.world.Spigot13Location;
import com.degoos.wetsponge.world.WSLocation;
import com.degoos.wetsponge.world.WSWorld;
import java.util.Optional;
import org.bukkit.block.Block;

public class Spigot13Block
implements WSBlock {
    private Block block;

    public Spigot13Block(Block block) {
        this.block = block;
    }

    @Override
    public WSLocation getLocation() {
        return new Spigot13Location(this.block.getLocation());
    }

    @Override
    public WSWorld getWorld() {
        return WorldParser.getOrCreateWorld(this.block.getWorld().getName(), this.block.getWorld());
    }

    @Override
    public int getNumericalId() {
        Optional<WSBlockType> optional = WSBlockTypes.getById(this.block.getType().getKey().toString());
        return optional.map(WSMaterial::getNumericalId).orElse(0);
    }

    @Override
    public String getStringId() {
        return WetSponge.getVersion().isOlderThan(EnumServerVersion.MINECRAFT_1_13) ? this.getOldStringId() : this.getNewStringId();
    }

    @Override
    public String getNewStringId() {
        return this.block.getType().getKey().toString();
    }

    @Override
    public String getOldStringId() {
        Optional<WSBlockType> optional = WSBlockTypes.getById(this.block.getType().getKey().toString());
        return optional.map(WSMaterial::getNewStringId).orElse("minecraft:air");
    }

    @Override
    public WSBlockState createState() {
        return new Spigot13BlockState(this);
    }

    @Override
    public Spigot13TileEntity getTileEntity() {
        switch (this.getNumericalId()) {
            case 23: {
                return new Spigot13TileEntityDispenser(this);
            }
            case 25: {
                return new Spigot13TileEntityNoteblock(this);
            }
            case 52: {
                return new Spigot13TileEntityMonsterSpawner(this);
            }
            case 54: 
            case 146: {
                return new Spigot13TileEntityChest(this);
            }
            case 61: 
            case 62: {
                return new Spigot13TileEntityFurnace(this);
            }
            case 63: 
            case 68: {
                return new Spigot13TileEntitySign(this);
            }
            case 84: {
                return new Spigot13TileEntityJukebox(this);
            }
            case 116: {
                return new Spigot13TileEntityNameable(this);
            }
            case 117: {
                return new Spigot13TileEntityBrewingStand(this);
            }
            case 137: {
                return new Spigot13TileEntityCommandBlock(this);
            }
            case 144: {
                return new Spigot13TileEntitySkull(this);
            }
            case 154: {
                return new Spigot13TileEntityNameableInventory(this);
            }
        }
        return new Spigot13TileEntity(this);
    }

    @Override
    public WSBlockType getBlockType() {
        String id = this.block.getType().getKey().toString();
        Optional<WSBlockType> optional = WSBlockTypes.getById(id);
        if (optional.isPresent()) {
            return ((Spigot13BlockType)optional.get()).readBlockData(this.block.getBlockData());
        }
        return new Spigot13BlockType(-1, id, id, this.block.getType().getMaxStackSize());
    }

    @Override
    public WSBlock getRelative(EnumBlockFace direction) {
        return this.getLocation().add(direction.getRelative().toDouble()).getBlock();
    }

    @Override
    public EnumMapBaseColor getMapBaseColor() {
        Object world = Spigot13HandledUtils.getWorldHandle(this.block.getWorld());
        Object blockPosition = Spigot13HandledUtils.getBlockPosition(this.block.getLocation());
        try {
            Object iBlockData = ReflectionUtils.invokeMethod(world, "getType", blockPosition);
            return Spigot13MapUtils.getMapBaseColor(iBlockData, world, blockPosition, this.getStringId());
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was getting the map base color of the block " + this.getStringId() + "!");
            return EnumMapBaseColor.AIR;
        }
    }

    public Block getHandled() {
        return this.block;
    }
}

