/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.bar;

import com.degoos.wetsponge.bar.WSBossBar;
import com.degoos.wetsponge.entity.living.player.SpongePlayer;
import com.degoos.wetsponge.entity.living.player.WSPlayer;
import com.degoos.wetsponge.enums.EnumBossBarColor;
import com.degoos.wetsponge.enums.EnumBossBarOverlay;
import com.degoos.wetsponge.parser.player.PlayerParser;
import com.degoos.wetsponge.text.SpongeText;
import com.degoos.wetsponge.text.WSText;
import java.util.Set;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.boss.BossBarColor;
import org.spongepowered.api.boss.BossBarColors;
import org.spongepowered.api.boss.BossBarOverlay;
import org.spongepowered.api.boss.BossBarOverlays;
import org.spongepowered.api.boss.ServerBossBar;

public class SpongeBossBar
implements WSBossBar {
    protected ServerBossBar bossBar;

    public SpongeBossBar(ServerBossBar bossBar) {
        this.bossBar = bossBar;
    }

    @Override
    public SpongeBossBar addPlayer(WSPlayer player) {
        this.bossBar.addPlayer(((SpongePlayer)player).getHandled());
        return this;
    }

    @Override
    public SpongeBossBar removePlayer(WSPlayer player) {
        this.bossBar.removePlayer(((SpongePlayer)player).getHandled());
        return this;
    }

    @Override
    public SpongeBossBar clearPlayers() {
        this.bossBar.removePlayers(this.bossBar.getPlayers());
        return this;
    }

    @Override
    public Set<WSPlayer> getPlayers() {
        return this.bossBar.getPlayers().stream().map(player -> PlayerParser.getOrCreatePlayer(player, player.getUniqueId())).collect(Collectors.toSet());
    }

    @Override
    public EnumBossBarColor getColor() {
        return EnumBossBarColor.getByName(this.bossBar.getColor().getName()).orElse(EnumBossBarColor.PURPLE);
    }

    @Override
    public SpongeBossBar setColor(EnumBossBarColor color) {
        this.bossBar.setColor(Sponge.getRegistry().getType(BossBarColor.class, color.name()).orElse(BossBarColors.PURPLE));
        return this;
    }

    @Override
    public EnumBossBarOverlay getOverlay() {
        return EnumBossBarOverlay.getBySpongeName(this.bossBar.getOverlay().getName()).orElse(EnumBossBarOverlay.PROGRESS);
    }

    @Override
    public SpongeBossBar setOverlay(EnumBossBarOverlay overlay) {
        this.bossBar.setOverlay(Sponge.getRegistry().getType(BossBarOverlay.class, overlay.getSpongeName()).orElse(BossBarOverlays.PROGRESS));
        return this;
    }

    @Override
    public float getPercent() {
        return this.bossBar.getPercent();
    }

    @Override
    public SpongeBossBar setPercent(float percent) {
        this.bossBar.setPercent(percent);
        return this;
    }

    @Override
    public boolean shouldCreateFog() {
        return this.bossBar.shouldCreateFog();
    }

    @Override
    public SpongeBossBar setCreateFog(boolean createFog) {
        this.bossBar.setCreateFog(createFog);
        return this;
    }

    @Override
    public boolean shouldDarkenSky(boolean darkenSky) {
        return this.bossBar.shouldDarkenSky();
    }

    @Override
    public SpongeBossBar setDarkenSky(boolean darkenSky) {
        this.bossBar.setDarkenSky(darkenSky);
        return this;
    }

    @Override
    public boolean shouldPlayEndBossMusic() {
        return this.bossBar.shouldPlayEndBossMusic();
    }

    @Override
    public SpongeBossBar setPlayEndBossMusic(boolean playEndBossMusic) {
        this.bossBar.setPlayEndBossMusic(playEndBossMusic);
        return this;
    }

    @Override
    public boolean isVisible() {
        return this.bossBar.isVisible();
    }

    @Override
    public SpongeBossBar setVisible(boolean visible) {
        this.bossBar.setVisible(visible);
        return this;
    }

    @Override
    public WSText getName() {
        return SpongeText.of(this.bossBar.getName());
    }

    @Override
    public SpongeBossBar setName(WSText name) {
        this.bossBar.setName(((SpongeText)name).getHandled());
        return this;
    }

    public ServerBossBar getHandled() {
        return this.bossBar;
    }

    public static class Builder
    implements WSBossBar.Builder {
        private ServerBossBar.Builder builder = ServerBossBar.builder();

        @Override
        public Builder color(EnumBossBarColor color) {
            this.builder.color(Sponge.getRegistry().getType(BossBarColor.class, color.name()).orElse(BossBarColors.PURPLE));
            return this;
        }

        @Override
        public Builder overlay(EnumBossBarOverlay overlay) {
            this.builder.overlay(Sponge.getRegistry().getType(BossBarOverlay.class, overlay.getSpongeName()).orElse(BossBarOverlays.PROGRESS));
            return this;
        }

        @Override
        public Builder percent(float percent) {
            this.builder.percent(percent);
            return this;
        }

        @Override
        public Builder createFog(boolean createFog) {
            this.builder.createFog(createFog);
            return this;
        }

        @Override
        public Builder darkenSky(boolean darkenSky) {
            this.builder.darkenSky(darkenSky);
            return this;
        }

        @Override
        public Builder playEndBossMusic(boolean endBossMusic) {
            this.builder.playEndBossMusic(endBossMusic);
            return this;
        }

        @Override
        public Builder visible(boolean visible) {
            this.builder.visible(visible);
            return this;
        }

        @Override
        public Builder name(WSText name) {
            this.builder.name(((SpongeText)name).getHandled());
            return this;
        }

        @Override
        public WSBossBar build() {
            return new SpongeBossBar(this.builder.build());
        }
    }
}

