/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.bar;

import com.degoos.wetsponge.SpigotWetSponge;
import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.bar.WSBossBar;
import com.degoos.wetsponge.effect.potion.WSPotionEffect;
import com.degoos.wetsponge.entity.living.complex.WSEnderDragon;
import com.degoos.wetsponge.entity.living.player.WSPlayer;
import com.degoos.wetsponge.enums.EnumBossBarColor;
import com.degoos.wetsponge.enums.EnumBossBarOverlay;
import com.degoos.wetsponge.enums.EnumPotionEffectType;
import com.degoos.wetsponge.packet.play.server.WSSPacketDestroyEntities;
import com.degoos.wetsponge.packet.play.server.WSSPacketSpawnMob;
import com.degoos.wetsponge.text.WSText;
import com.degoos.wetsponge.world.WSWorld;
import com.flowpowered.math.vector.Vector3d;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class OldSpigotBossBar
implements WSBossBar {
    private static int count = 0;
    private WSEnderDragon enderDragon;
    private Set<WSPlayer> players = new HashSet<WSPlayer>();
    private boolean visible;
    private int id = 1000 + count;

    public OldSpigotBossBar() {
        ++count;
        WSWorld world = WetSponge.getServer().getWorlds().stream().findAny().orElse(null);
        if (world == null) {
            this.enderDragon = null;
            return;
        }
        this.enderDragon = world.createEntity(WSEnderDragon.class, new Vector3d()).orElse(null);
        if (this.enderDragon != null) {
            this.enderDragon.addPotionEffect(WSPotionEffect.builder().type(EnumPotionEffectType.INVISIBILITY).duration(Integer.MAX_VALUE).amplifier(2).build());
        }
        new BukkitRunnable(){

            public void run() {
                OldSpigotBossBar.this.sendSpawnPacket(OldSpigotBossBar.this.players);
            }
        }.runTaskTimer((Plugin)SpigotWetSponge.getInstance(), 10L, 10L);
    }

    @Override
    public WSBossBar addPlayer(WSPlayer player) {
        this.players.add(player);
        this.sendSpawnPacket(player);
        return this;
    }

    @Override
    public WSBossBar removePlayer(WSPlayer player) {
        this.players.remove(player);
        this.sendDestroyPacket(player);
        return this;
    }

    @Override
    public WSBossBar clearPlayers() {
        this.sendDestroyPacket(this.players);
        this.players.clear();
        return this;
    }

    @Override
    public Set<WSPlayer> getPlayers() {
        return new HashSet<WSPlayer>(this.players);
    }

    @Override
    public EnumBossBarColor getColor() {
        return EnumBossBarColor.PURPLE;
    }

    @Override
    public WSBossBar setColor(EnumBossBarColor color) {
        return this;
    }

    @Override
    public EnumBossBarOverlay getOverlay() {
        return EnumBossBarOverlay.PROGRESS;
    }

    @Override
    public WSBossBar setOverlay(EnumBossBarOverlay overlay) {
        return this;
    }

    @Override
    public float getPercent() {
        return this.enderDragon == null ? 0.0f : (float)(this.enderDragon.getHealth() / this.enderDragon.getMaxHealth());
    }

    @Override
    public WSBossBar setPercent(float percent) {
        if (this.enderDragon != null) {
            this.enderDragon.setHealth(this.enderDragon.getMaxHealth() * (double)percent);
        }
        return this;
    }

    @Override
    public boolean shouldCreateFog() {
        return false;
    }

    @Override
    public WSBossBar setCreateFog(boolean createFog) {
        return this;
    }

    @Override
    public boolean shouldDarkenSky(boolean darkenSky) {
        return false;
    }

    @Override
    public WSBossBar setDarkenSky(boolean darkenSky) {
        return this;
    }

    @Override
    public boolean shouldPlayEndBossMusic() {
        return false;
    }

    @Override
    public WSBossBar setPlayEndBossMusic(boolean playEndBossMusic) {
        return this;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public WSBossBar setVisible(boolean visible) {
        this.visible = visible;
        if (visible) {
            this.sendSpawnPacket(this.players);
        } else {
            this.sendDestroyPacket(this.players);
        }
        return this;
    }

    @Override
    public WSText getName() {
        return this.enderDragon.getCustomName().orElse(WSText.empty());
    }

    @Override
    public WSBossBar setName(WSText name) {
        if (this.enderDragon != null) {
            this.enderDragon.setCustomName(name);
        }
        return this;
    }

    @Override
    public OldSpigotBossBar getHandled() {
        return this;
    }

    private void sendSpawnPacket(WSPlayer player) {
        if (!this.visible || this.enderDragon == null) {
            return;
        }
        WSSPacketSpawnMob spawnMob = WSSPacketSpawnMob.of(this.enderDragon);
        spawnMob.setEntityId(this.id);
        spawnMob.setPosition(player.getLocation().setY(Math.min(-10.0, player.getLocation().getY() - 100.0)).toVector3d());
        player.sendPacket(spawnMob);
    }

    private void sendSpawnPacket(Set<WSPlayer> players) {
        if (!this.visible || this.enderDragon == null) {
            return;
        }
        players.forEach(player -> {
            WSSPacketSpawnMob spawnMob = WSSPacketSpawnMob.of(this.enderDragon);
            spawnMob.setEntityId(this.id);
            spawnMob.setPosition(player.getLocation().setY(Math.min(-10.0, player.getLocation().getY() - 100.0)).toVector3d());
            player.sendPacket(spawnMob);
        });
    }

    private void sendDestroyPacket(WSPlayer player) {
        player.sendPacket(WSSPacketDestroyEntities.of(this.id));
    }

    private void sendDestroyPacket(Set<WSPlayer> players) {
        WSSPacketDestroyEntities packet = WSSPacketDestroyEntities.of(this.id);
        players.forEach(player -> player.sendPacket(packet));
    }

    public static class Builder
    implements WSBossBar.Builder {
        private EnumBossBarColor color = EnumBossBarColor.PURPLE;
        private EnumBossBarOverlay overlay = EnumBossBarOverlay.PROGRESS;
        private float percent = 1.0f;
        private boolean createFog = false;
        private boolean darkenSky = false;
        private boolean endBossMusic = false;
        private boolean visible = false;
        private WSText name = WSText.of("");

        @Override
        public Builder color(EnumBossBarColor color) {
            this.color = color;
            return this;
        }

        @Override
        public Builder overlay(EnumBossBarOverlay overlay) {
            this.overlay = overlay;
            return this;
        }

        @Override
        public Builder percent(float percent) {
            this.percent = percent;
            return this;
        }

        @Override
        public Builder createFog(boolean createFog) {
            this.createFog = createFog;
            return this;
        }

        @Override
        public Builder darkenSky(boolean darkenSky) {
            this.darkenSky = darkenSky;
            return this;
        }

        @Override
        public Builder playEndBossMusic(boolean endBossMusic) {
            this.endBossMusic = endBossMusic;
            return this;
        }

        @Override
        public Builder visible(boolean visible) {
            this.visible = visible;
            return this;
        }

        @Override
        public Builder name(WSText name) {
            this.name = name;
            return this;
        }

        @Override
        public WSBossBar build() {
            OldSpigotBossBar bossBar = new OldSpigotBossBar();
            bossBar.setName(this.name);
            bossBar.setColor(this.color);
            bossBar.setOverlay(this.overlay);
            bossBar.setVisible(this.visible);
            bossBar.setPercent(this.percent);
            bossBar.setCreateFog(this.createFog);
            bossBar.setDarkenSky(this.darkenSky);
            bossBar.setPlayEndBossMusic(this.endBossMusic);
            return bossBar;
        }
    }
}

