/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge;

import com.degoos.wetsponge.command.WSCommandManager;
import com.degoos.wetsponge.command.wetspongecommand.WetSpongeCommand;
import com.degoos.wetsponge.config.WetSpongeConfig;
import com.degoos.wetsponge.config.WetSpongeMessages;
import com.degoos.wetsponge.enums.EnumServerType;
import com.degoos.wetsponge.enums.EnumServerVersion;
import com.degoos.wetsponge.event.WSEventManager;
import com.degoos.wetsponge.hook.WSHookManager;
import com.degoos.wetsponge.inventory.multiinventory.MultiInventoryListener;
import com.degoos.wetsponge.loader.WetSpongeLoader;
import com.degoos.wetsponge.plugin.WSPlugin;
import com.degoos.wetsponge.plugin.WSPluginManager;
import com.degoos.wetsponge.resource.SQLDriverUtils;
import com.degoos.wetsponge.resource.WSBungeeCord;
import com.degoos.wetsponge.server.WSServer;
import com.degoos.wetsponge.timing.WSTimings;
import com.degoos.wetsponge.util.InternalLogger;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class WetSponge {
    private static EnumServerType serverType;
    private static WetSpongeLoader loader;
    private static WSServer server;
    private static EnumServerVersion version;
    private static WSBungeeCord bungeeCord;
    private static Thread mainThread;
    private static String wetSpongeVersion;
    private static WSTimings timings;

    protected static void load(String wetSpongeVersion, EnumServerType serverType, WetSpongeLoader loader, WSServer server, EnumServerVersion version, WSBungeeCord bungeeCord, Thread mainThread) {
        Logger.getLogger("org.jooq.Constants").setLevel(Level.OFF);
        WetSponge.wetSpongeVersion = wetSpongeVersion;
        WetSponge.serverType = serverType;
        WetSponge.loader = loader;
        WetSponge.server = server;
        WetSponge.version = version;
        WetSponge.bungeeCord = bungeeCord;
        WetSponge.mainThread = mainThread;
    }

    protected static void loadCommon() {
        InternalLogger.sendInfo("Loading config.");
        WetSpongeConfig.load();
        InternalLogger.sendInfo("Loading timings.");
        timings = new WSTimings();
        timings.startTiming("WetSponge load");
        InternalLogger.sendInfo("Loading database drivers.");
        InternalLogger.sendInfo("WetSponge implements JOOQ, so developers can use it to handle connections to databases.");
        SQLDriverUtils.loadDrivers();
        InternalLogger.sendDebug("Debug mode activated.");
        InternalLogger.sendInfo("Loading messages.");
        WetSpongeMessages.load();
        InternalLogger.sendInfo("Loading MultiInventory API.");
        MultiInventoryListener.load();
        InternalLogger.sendInfo("Loading hooks.");
        WSHookManager.getInstance();
        InternalLogger.sendInfo("Loading WetSponge commands.");
        WetSponge.getCommandManager().addCommand(new WetSpongeCommand());
        timings.stopTiming();
        InternalLogger.sendInfo("Loading plugins.");
        WetSponge.getPluginManager().loadPlugins();
    }

    protected static void unloadCommon() {
        WetSponge.getPluginManager().getPlugins().forEach(plugin -> WetSponge.getPluginManager().unloadPlugin((WSPlugin)plugin));
    }

    public static boolean is(EnumServerType serverType) {
        return WetSponge.serverType == serverType;
    }

    @Deprecated
    public static boolean isSpigot() {
        return serverType == EnumServerType.SPIGOT;
    }

    @Deprecated
    public static boolean isSponge() {
        return serverType == EnumServerType.SPONGE;
    }

    public static EnumServerType getServerType() {
        return serverType;
    }

    public static String getWetSpongeVersion() {
        return wetSpongeVersion;
    }

    public static WetSpongeLoader getLoader() {
        return loader;
    }

    public static EnumServerVersion getVersion() {
        return version;
    }

    public static WSServer getServer() {
        return server;
    }

    public static WSBungeeCord getBungeeCord() {
        return bungeeCord;
    }

    public static WSEventManager getEventManager() {
        return WSEventManager.getInstance();
    }

    public static WSPluginManager getPluginManager() {
        return WSPluginManager.getInstance();
    }

    public static WSCommandManager getCommandManager() {
        return WSCommandManager.getInstance();
    }

    public static WSHookManager getHookManager() {
        return WSHookManager.getInstance();
    }

    public static WSTimings getTimings() {
        return timings;
    }

    public static Thread getMainThread() {
        return mainThread;
    }

    static {
        LogManager.getLogManager().reset();
    }
}

