/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.command.wetspongecommand.SpigotWetspongeCommand;
import com.degoos.wetsponge.enums.EnumEntityType;
import com.degoos.wetsponge.enums.EnumServerType;
import com.degoos.wetsponge.enums.EnumServerVersion;
import com.degoos.wetsponge.enums.EnumTextColor;
import com.degoos.wetsponge.loader.SpigotListenerLoader;
import com.degoos.wetsponge.loader.SpigotWetSpongeLoader;
import com.degoos.wetsponge.mixin.spigot.SpigotInjector;
import com.degoos.wetsponge.parser.entity.SpigotEntityParser;
import com.degoos.wetsponge.resource.spigot.SpigotBungeeCord;
import com.degoos.wetsponge.server.SpigotServer;
import com.degoos.wetsponge.text.WSText;
import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.util.reflection.SpigotServerUtils;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SpigotOldWetSponge
implements SpigotWetSpongeLoader {
    public void onEnable(final JavaPlugin instance, final EnumServerVersion version) {
        new BukkitRunnable(){

            public void run() {
                try {
                    long millis = System.currentTimeMillis();
                    EnumServerType type = EnumServerType.SPIGOT;
                    try {
                        Class.forName("com.destroystokyo.paper.PaperConfig");
                        type = EnumServerType.PAPER_SPIGOT;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    WetSponge.load(instance.getDescription().getVersion(), type, SpigotOldWetSponge.this, new SpigotServer(Bukkit.getServer()), version, new SpigotBungeeCord(instance), SpigotServerUtils.getMainThread());
                    InternalLogger.sendInfo("Loading WetSponge " + instance.getDescription().getVersion() + "...");
                    InternalLogger.sendInfo(WSText.builder("Using version ").append(WSText.builder("SPIGOT " + version.name()).color(EnumTextColor.GREEN).build()).build());
                    InternalLogger.sendInfo("Loading entities.");
                    SpigotEntityParser.load();
                    Arrays.stream(EnumEntityType.values()).forEach(EnumEntityType::load);
                    InternalLogger.sendInfo("Loading Spigot listeners.");
                    SpigotListenerLoader.load();
                    InternalLogger.sendInfo("Loading injectors.");
                    SpigotInjector.inject(instance);
                    InternalLogger.sendInfo("Loading common.");
                    WetSponge.loadCommon();
                    instance.getCommand("wetSpongeCmd").setExecutor((CommandExecutor)new SpigotWetspongeCommand());
                    double secs = (double)(System.currentTimeMillis() - millis) / 1000.0;
                    InternalLogger.sendDone(WSText.builder("WetSponge has been loaded in ").append(WSText.builder(String.valueOf(secs)).color(EnumTextColor.RED).build()).append(WSText.builder(" seconds!").color(EnumTextColor.GREEN).build()).build());
                }
                catch (Throwable ex) {
                    InternalLogger.printException(ex, "An error has occurred while WetSponge was loading!");
                }
            }
        }.runTaskLater((Plugin)instance, 1L);
    }

    @Override
    public void onDisable() {
        try {
            WetSponge.unloadCommon();
        }
        catch (Throwable ex) {
            InternalLogger.printException(ex, "An error has occurred while WetSponge was unloading!");
        }
    }
}

