/*
 * Decompiled with CFR 0.152.
 */
package com.deepl.api.parsing;

import com.deepl.api.DocumentHandle;
import com.deepl.api.DocumentStatus;
import com.deepl.api.GlossaryInfo;
import com.deepl.api.GlossaryLanguagePair;
import com.deepl.api.Language;
import com.deepl.api.MultilingualGlossaryDictionaryInfo;
import com.deepl.api.MultilingualGlossaryInfo;
import com.deepl.api.TextResult;
import com.deepl.api.Usage;
import com.deepl.api.WriteResult;
import com.deepl.api.parsing.ErrorResponse;
import com.deepl.api.parsing.GlossaryLanguagesResponse;
import com.deepl.api.parsing.GlossaryListResponse;
import com.deepl.api.parsing.LanguageDeserializer;
import com.deepl.api.parsing.MultilingualGlossaryDictionaryListResponse;
import com.deepl.api.parsing.MultilingualGlossaryListResponse;
import com.deepl.api.parsing.TextResponse;
import com.deepl.api.parsing.TextResultDeserializer;
import com.deepl.api.parsing.UsageDeserializer;
import com.deepl.api.parsing.WriteResponse;
import com.deepl.api.parsing.WriteResultDeserializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class Parser {
    private final Gson gson;

    public Parser() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(TextResult.class, (Object)new TextResultDeserializer());
        gsonBuilder.registerTypeAdapter(WriteResult.class, (Object)new WriteResultDeserializer());
        gsonBuilder.registerTypeAdapter(Language.class, (Object)new LanguageDeserializer());
        gsonBuilder.registerTypeAdapter(Usage.class, (Object)new UsageDeserializer());
        this.gson = gsonBuilder.create();
    }

    public List<TextResult> parseTextResult(String json) {
        TextResponse result = (TextResponse)this.gson.fromJson(json, TextResponse.class);
        return result.translations;
    }

    public List<WriteResult> parseWriteResult(String json) {
        WriteResponse result = (WriteResponse)this.gson.fromJson(json, WriteResponse.class);
        return result.improvements;
    }

    public Usage parseUsage(String json) {
        return (Usage)this.gson.fromJson(json, Usage.class);
    }

    public List<Language> parseLanguages(String json) {
        Type languageListType = new TypeToken<ArrayList<Language>>(){}.getType();
        return (List)this.gson.fromJson(json, languageListType);
    }

    public List<GlossaryLanguagePair> parseGlossaryLanguageList(String json) {
        return ((GlossaryLanguagesResponse)this.gson.fromJson(json, GlossaryLanguagesResponse.class)).getSupportedLanguages();
    }

    public DocumentStatus parseDocumentStatus(String json) {
        return (DocumentStatus)this.gson.fromJson(json, DocumentStatus.class);
    }

    public DocumentHandle parseDocumentHandle(String json) {
        return (DocumentHandle)this.gson.fromJson(json, DocumentHandle.class);
    }

    public GlossaryInfo parseGlossaryInfo(String json) {
        return (GlossaryInfo)this.gson.fromJson(json, GlossaryInfo.class);
    }

    public MultilingualGlossaryInfo parseMultilingualGlossaryInfo(String json) {
        return (MultilingualGlossaryInfo)this.gson.fromJson(json, MultilingualGlossaryInfo.class);
    }

    public MultilingualGlossaryDictionaryListResponse parseMultilingualGlossaryDictionaryListResponse(String json) {
        return (MultilingualGlossaryDictionaryListResponse)this.gson.fromJson(json, MultilingualGlossaryDictionaryListResponse.class);
    }

    public List<GlossaryInfo> parseGlossaryInfoList(String json) {
        GlossaryListResponse result = (GlossaryListResponse)this.gson.fromJson(json, GlossaryListResponse.class);
        return result.getGlossaries();
    }

    public List<MultilingualGlossaryInfo> parseMultilingualGlossaryInfoList(String json) {
        MultilingualGlossaryListResponse result = (MultilingualGlossaryListResponse)this.gson.fromJson(json, MultilingualGlossaryListResponse.class);
        return result.getGlossaries();
    }

    public MultilingualGlossaryDictionaryInfo parseMultilingualGlossaryDictionaryInfo(String json) {
        return (MultilingualGlossaryDictionaryInfo)this.gson.fromJson(json, MultilingualGlossaryDictionaryInfo.class);
    }

    public String parseErrorMessage(String json) {
        ErrorResponse response = (ErrorResponse)this.gson.fromJson(json, ErrorResponse.class);
        if (response != null) {
            return response.getErrorMessage();
        }
        return "";
    }

    @Nullable
    static Integer getAsIntOrNull(JsonObject jsonObject, String parameterName) {
        if (!jsonObject.has(parameterName)) {
            return null;
        }
        return jsonObject.get(parameterName).getAsInt();
    }

    @Nullable
    static Long getAsLongOrNull(JsonObject jsonObject, String parameterName) {
        if (!jsonObject.has(parameterName)) {
            return null;
        }
        return jsonObject.get(parameterName).getAsLong();
    }

    @Nullable
    static String getAsStringOrNull(JsonObject jsonObject, String parameterName) {
        if (!jsonObject.has(parameterName)) {
            return null;
        }
        return jsonObject.get(parameterName).getAsString();
    }

    @Nullable
    static Boolean getAsBooleanOrNull(JsonObject jsonObject, String parameterName) {
        if (!jsonObject.has(parameterName)) {
            return null;
        }
        return jsonObject.get(parameterName).getAsBoolean();
    }
}

