/*
 * Decompiled with CFR 0.152.
 */
package com.davidehrmann.vcdiff;

import com.beust.jcommander.IParameterValidator;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import com.davidehrmann.vcdiff.VCDiffDecoderBuilder;
import com.davidehrmann.vcdiff.VCDiffEncoderBuilder;
import com.davidehrmann.vcdiff.io.ComparingOutputStream;
import com.davidehrmann.vcdiff.io.CountingInputStream;
import com.davidehrmann.vcdiff.io.CountingOutputStream;
import com.davidehrmann.vcdiff.io.IOUtils;
import com.davidehrmann.vcdiff.io.VCDiffInputStream;
import com.davidehrmann.vcdiff.io.VCDiffOutputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.ListIterator;

public class VCDiffFileBasedCoder {
    public static final int DEFAULT_MAX_TARGET_SIZE = 0x4000000;

    private VCDiffFileBasedCoder() {
    }

    private static InputStream OpenFileForReading(String file_name, String file_type) throws FileNotFoundException {
        try {
            return new InputStreamExceptionMapper(new FileInputStream(file_name), file_type);
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException(String.format("Error opening %s file: %s", file_type, e.getMessage()));
        }
    }

    private static OutputStream OpenFileForWriting(String file_name, String file_type) throws FileNotFoundException {
        try {
            return new OutputStreamExceptionMapper(new FileOutputStream(file_name), file_type);
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException(String.format("Error opening %s file: %s", file_type, e.getMessage()));
        }
    }

    protected static byte[] OpenDictionary(String dictionary) throws IOException {
        InputStream in = VCDiffFileBasedCoder.OpenFileForReading(dictionary, "dictionary");
        try {
            byte[] byArray = IOUtils.toByteArray((InputStream)in);
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((Closeable)in);
        }
    }

    public static void main(String[] argv) throws Exception {
        LinkedList<String> newArgv = new LinkedList<String>(Arrays.asList(argv));
        ListIterator<String> i = newArgv.listIterator();
        while (i.hasNext()) {
            String arg = (String)i.next();
            if (arg.matches("--?allow_vcd_target") && i.hasNext()) {
                String val = (String)i.next();
                if (val.matches("(?i)true|yes|1")) {
                    i.remove();
                } else if (val.matches("(?i)false|no|0")) {
                    i.remove();
                    i.previous();
                    i.remove();
                } else {
                    i.previous();
                }
            } else if (arg.matches("--?allow_vcd_target(=.*)?")) {
                if (arg.matches("(?i)--?allow_vcd_target=(true|yes|1)")) {
                    i.set("-allow_vcd_target");
                } else if (arg.matches("(?i)--?allow_vcd_target=(false|no|0)")) {
                    i.remove();
                }
            }
            argv = newArgv.toArray(new String[newArgv.size()]);
        }
        EncodeCommand encodeCommand = new EncodeCommand();
        DecodeCommand decodeCommand = new DecodeCommand();
        DecodeAndCompareCommand decodeAndCompareCommand = new DecodeAndCompareCommand();
        JCommander jCommander = new JCommander();
        jCommander.addCommand("encode", (Object)encodeCommand, new String[]{"delta"});
        jCommander.addCommand("decode", (Object)decodeCommand, new String[]{"patch"});
        jCommander.addCommand("test", (Object)decodeAndCompareCommand);
        try {
            jCommander.parse(argv);
        }
        catch (ParameterException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        String command_name = VCDiffFileBasedCoder.class.getCanonicalName();
        String command_option = jCommander.getParsedCommand();
        try {
            if ("encode".equals(command_option) || "delta".equals(command_option)) {
                encodeCommand.Encode();
            } else if ("decode".equals(command_option) || "patch".equals(command_option)) {
                decodeCommand.Decode();
            } else if ("test".equals(command_option)) {
                JCommander jCommander2 = new JCommander();
                jCommander2.addObject((Object)encodeCommand);
                jCommander2.parse(Arrays.copyOfRange(argv, 1, argv.length));
                encodeCommand.Encode();
                decodeAndCompareCommand.DecodeAndCompare();
            } else {
                System.err.printf("%s: Unrecognized command option %s%n", command_name, command_option);
                jCommander.usage();
                System.exit(1);
            }
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    @Parameters(hidden=true, separators=" =")
    private static class DecodeAndCompareCommand
    extends VCDiffFileBasedCoder {
        @ParametersDelegate
        private GlobalOptions globalOptions = new GlobalOptions();
        @ParametersDelegate
        private EncodeOptions encodeOptions = new EncodeOptions();
        @ParametersDelegate
        private DecodeOptions decodeOptions = new DecodeOptions();
        @ParametersDelegate
        private RequiredTargetAndDeltaOptions targetAndDeltaOptions = new RequiredTargetAndDeltaOptions();

        private DecodeAndCompareCommand() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void DecodeAndCompare() throws IOException {
            byte[] dictionary = DecodeAndCompareCommand.OpenDictionary(this.globalOptions.dictionary);
            try (CountingInputStream countedIn = new CountingInputStream(VCDiffFileBasedCoder.OpenFileForReading(this.targetAndDeltaOptions.delta, "delta"));){
                VCDiffInputStream in = VCDiffDecoderBuilder.builder().withMaxTargetFileSize(this.globalOptions.maxTargetFileSize).withMaxTargetWindowSize(this.globalOptions.maxTargetWindowSize).withAllowTargetMatches(this.decodeOptions.allowVcdTarget).buildInputStream((InputStream)countedIn, dictionary);
                try {
                    InputStream expected = VCDiffFileBasedCoder.OpenFileForReading(this.targetAndDeltaOptions.target, "target");
                    try {
                        CountingOutputStream out = new CountingOutputStream((OutputStream)new ComparingOutputStream(expected));
                        try {
                            IOUtils.copyLarge((InputStream)in, (OutputStream)out, (byte[])new byte[this.globalOptions.bufferSize]);
                            out.close();
                            if (this.globalOptions.stats && out.getBytesWritten() > 0L) {
                                System.err.printf("Decompressed size: %d\tCompressed size: %d (%.2f%% of original)%n", out.getBytesWritten(), countedIn.getBytesRead(), 100.0 * (double)countedIn.getBytesRead() / (double)out.getBytesWritten());
                            }
                        }
                        finally {
                            IOUtils.closeQuietly((Closeable)out);
                        }
                    }
                    finally {
                        IOUtils.closeQuietly((Closeable)expected);
                    }
                }
                finally {
                    IOUtils.closeQuietly((Closeable)in);
                }
            }
        }
    }

    @Parameters(commandDescription="Reconstruct target file from dictionary and delta file", separators=" =")
    private static class DecodeCommand
    extends VCDiffFileBasedCoder {
        @ParametersDelegate
        private GlobalOptions globalOptions = new GlobalOptions();
        @ParametersDelegate
        private DecodeOptions decodeOptions = new DecodeOptions();
        @ParametersDelegate
        private OptionalTargetAndDeltaOptions targetAndDeltaFlags = new OptionalTargetAndDeltaOptions();

        private DecodeCommand() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void Decode() throws IOException {
            byte[] dictionary = DecodeCommand.OpenDictionary(this.globalOptions.dictionary);
            boolean useStdin = this.targetAndDeltaFlags.delta == null || this.targetAndDeltaFlags.delta.isEmpty();
            boolean useStdout = this.targetAndDeltaFlags.target == null || this.targetAndDeltaFlags.target.isEmpty();
            CountingInputStream countedIn = new CountingInputStream(useStdin ? new InputStreamExceptionMapper(System.in, "delta") : VCDiffFileBasedCoder.OpenFileForReading(this.targetAndDeltaFlags.delta, "delta"));
            try {
                VCDiffInputStream vcDiffIn = VCDiffDecoderBuilder.builder().withMaxTargetFileSize(this.globalOptions.maxTargetFileSize).withMaxTargetWindowSize(this.globalOptions.maxTargetWindowSize).withAllowTargetMatches(this.decodeOptions.allowVcdTarget).buildInputStream((InputStream)countedIn, dictionary);
                try {
                    CountingOutputStream out = new CountingOutputStream(useStdout ? new OutputStreamExceptionMapper(System.out, "target") : VCDiffFileBasedCoder.OpenFileForWriting(this.targetAndDeltaFlags.target, "target"));
                    try {
                        IOUtils.copyLarge((InputStream)vcDiffIn, (OutputStream)out, (byte[])new byte[this.globalOptions.bufferSize]);
                        if (this.globalOptions.stats && out.getBytesWritten() > 0L) {
                            System.err.printf("Decompressed size: %d\tCompressed size: %d (%.2f%% of original)%n", out.getBytesWritten(), countedIn.getBytesRead(), 100.0 * (double)countedIn.getBytesRead() / (double)out.getBytesWritten());
                        }
                    }
                    finally {
                        IOUtils.closeQuietly((Closeable)out);
                    }
                }
                finally {
                    IOUtils.closeQuietly((Closeable)vcDiffIn);
                }
            }
            finally {
                IOUtils.closeQuietly((Closeable)countedIn);
            }
        }
    }

    @Parameters(commandDescription="Create delta file from dictionary and target file", separators=" =")
    private static class EncodeCommand
    extends VCDiffFileBasedCoder {
        @ParametersDelegate
        private EncodeOptions encodeOptions = new EncodeOptions();
        @ParametersDelegate
        private GlobalOptions globalOptions = new GlobalOptions();
        @ParametersDelegate
        private OptionalTargetAndDeltaOptions targetAndDeltaOptions = new OptionalTargetAndDeltaOptions();

        private EncodeCommand() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void Encode() throws IOException {
            byte[] dictionary = EncodeCommand.OpenDictionary(this.globalOptions.dictionary);
            boolean useStdin = this.targetAndDeltaOptions.target == null || this.targetAndDeltaOptions.target.isEmpty();
            boolean useStdout = this.targetAndDeltaOptions.delta == null || this.targetAndDeltaOptions.delta.isEmpty();
            InputStream fileIn = useStdin ? new InputStreamExceptionMapper(System.in, "target") : VCDiffFileBasedCoder.OpenFileForReading(this.targetAndDeltaOptions.target, "target");
            try {
                CountingInputStream countingIn = new CountingInputStream(fileIn);
                try {
                    OutputStream fileOut = useStdout ? new OutputStreamExceptionMapper(System.out, "delta") : VCDiffFileBasedCoder.OpenFileForWriting(this.targetAndDeltaOptions.delta, "delta");
                    try {
                        CountingOutputStream countingOut = new CountingOutputStream(fileOut);
                        try {
                            VCDiffOutputStream vcDiffOut = VCDiffEncoderBuilder.builder().withDictionary(dictionary).withTargetMatches(this.encodeOptions.targetMatches).withChecksum(this.encodeOptions.checksum).withInterleaving(this.encodeOptions.interleaved).buildOutputStream((OutputStream)countingOut);
                            try {
                                IOUtils.copyLarge((InputStream)countingIn, (OutputStream)vcDiffOut, (byte[])new byte[this.globalOptions.bufferSize]);
                            }
                            finally {
                                IOUtils.closeQuietly((Closeable)vcDiffOut);
                            }
                        }
                        finally {
                            IOUtils.closeQuietly((Closeable)countingOut);
                        }
                        if (this.globalOptions.stats && countingIn.getBytesRead() > 0L) {
                            System.err.printf("Original size: %d\tCompressed size: %d (%.2f%% of original)%n", countingIn.getBytesRead(), countingOut.getBytesWritten(), 100.0 * (double)countingOut.getBytesWritten() / (double)countingIn.getBytesRead());
                        }
                    }
                    finally {
                        IOUtils.closeQuietly((Closeable)fileOut);
                    }
                }
                finally {
                    IOUtils.closeQuietly((Closeable)countingIn);
                }
            }
            finally {
                IOUtils.closeQuietly((Closeable)fileIn);
            }
        }
    }

    protected static class OutputStreamExceptionMapper
    extends FilterOutputStream {
        private final String type;

        public OutputStreamExceptionMapper(OutputStream out, String type) {
            super(out);
            this.type = type;
        }

        @Override
        public void write(int b) throws IOException {
            try {
                super.write(b);
            }
            catch (IOException e) {
                throw new IOException(String.format("Error writing %d byte to %s file: %s", 1, this.type, e.getMessage()));
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            try {
                this.out.write(b, off, len);
            }
            catch (IOException e) {
                throw new IOException(String.format("Error writing %d byte(s) to %s file: %s", len, this.type, e.getMessage()));
            }
        }

        @Override
        public void flush() throws IOException {
            try {
                super.flush();
            }
            catch (IOException e) {
                throw new IOException(String.format("Error flushing %s file: %s", this.type, e.getMessage()));
            }
        }

        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            catch (IOException e) {
                throw new IOException(String.format("Error closing %s file: %s%n", this.type, e.getMessage()));
            }
        }
    }

    protected static class InputStreamExceptionMapper
    extends FilterInputStream {
        private final String type;

        protected InputStreamExceptionMapper(InputStream in, String type) {
            super(in);
            this.type = type;
        }

        @Override
        public int read() throws IOException {
            try {
                return super.read();
            }
            catch (IOException e) {
                throw new IOException(String.format("Error reading from %s file: %s%n", this.type, e.getMessage()));
            }
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            try {
                return super.read(b, off, len);
            }
            catch (IOException e) {
                throw new IOException(String.format("Error reading from %s file: %s%n", this.type, e.getMessage()));
            }
        }

        @Override
        public long skip(long n) throws IOException {
            try {
                return super.skip(n);
            }
            catch (IOException e) {
                throw new IOException(String.format("Error reading from %s file: %s%n", this.type, e.getMessage()));
            }
        }

        @Override
        public int available() throws IOException {
            try {
                return super.available();
            }
            catch (IOException e) {
                throw new IOException(String.format("Error reading from %s file: %s%n", this.type, e.getMessage()));
            }
        }

        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            catch (IOException e) {
                throw new IOException(String.format("Error closing %s file: %s", this.type, e.getMessage()));
            }
        }
    }

    protected static class GlobalOptions {
        @Parameter(names={"-dictionary", "--dictionary"}, description="File containing dictionary data (required)", required=true)
        protected String dictionary;
        @Parameter(names={"-max_target_file_size", "--max_target_file_size"}, description="Maximum target file size allowed by decoder")
        protected long maxTargetFileSize = 0x4000000L;
        @Parameter(names={"-max_target_window_size", "--max_target_window_size"}, description="Maximum target window size allowed by decoder")
        protected int maxTargetWindowSize = 0x4000000;
        @Parameter(names={"-buffersize", "--buffersize"}, description="Buffer size for reading input file", validateWith=PositiveInteger.class)
        protected int bufferSize = 0x100000;
        @Parameter(names={"-stats", "--stats"}, description="Report compression percentage")
        protected boolean stats = false;

        protected GlobalOptions() {
        }
    }

    protected static class DecodeOptions {
        @Parameter(names={"-allow_vcd_target", "--allow_vcd_target"}, description="If false, the decoder issues an error when the VCD_TARGET flag is encountered")
        protected boolean allowVcdTarget = true;

        protected DecodeOptions() {
        }
    }

    protected static class EncodeOptions {
        @Parameter(names={"-checksum", "--checksum"}, description="Include an Adler32 checksum of the target data when encoding")
        protected boolean checksum = false;
        @Parameter(names={"-interleaved", "--interleaved"}, description="Use interleaved format")
        protected boolean interleaved = false;
        @Parameter(names={"-json", "--json"}, description="output diff in the JSON format when encoding")
        protected boolean json = false;
        @Parameter(names={"-target_matches", "--target_matches"}, description="Find duplicate strings in target data as well as dictionary data")
        protected boolean targetMatches = false;

        protected EncodeOptions() {
        }
    }

    private static class RequiredTargetAndDeltaOptions {
        @Parameter(names={"-target", "--target"}, description="Target file", required=true)
        protected String target;
        @Parameter(names={"-delta", "--delta"}, description="Encoded delta file", required=true)
        protected String delta;

        private RequiredTargetAndDeltaOptions() {
        }
    }

    private static class OptionalTargetAndDeltaOptions {
        @Parameter(names={"-target", "--target"}, description="Target file (default is stdin for encode, stdout for decode)")
        protected String target;
        @Parameter(names={"-delta", "--delta"}, description="Encoded delta file (default is stdout for encode, stdin for decode)")
        protected String delta;

        private OptionalTargetAndDeltaOptions() {
        }
    }

    public static class PositiveInteger
    implements IParameterValidator {
        public void validate(String name, String value) throws ParameterException {
            int n = Integer.parseInt(value);
            if (n <= 0) {
                throw new ParameterException("Parameter " + name + " should be positive (found " + value + ")");
            }
        }
    }
}

