/*
 * Decompiled with CFR 0.152.
 */
package com.datatheorem.android.trustkit.config;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.datatheorem.android.trustkit.config.ConfigurationException;
import com.datatheorem.android.trustkit.config.DomainValidator;
import com.datatheorem.android.trustkit.config.PublicKeyPin;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public final class DomainPinningPolicy {
    private static final URL DEFAULT_REPORTING_URL;
    @NonNull
    private final String hostname;
    private final boolean shouldIncludeSubdomains;
    @NonNull
    private final Set<PublicKeyPin> publicKeyPins;
    @Nullable
    private final Date expirationDate;
    private final boolean shouldEnforcePinning;
    @NonNull
    private final Set<URL> reportUris;

    DomainPinningPolicy(@NonNull String hostname, Boolean shouldIncludeSubdomains, Set<String> publicKeyHashStrList, Boolean shouldEnforcePinning, @Nullable Date expirationDate, @Nullable Set<String> reportUriStrList, Boolean shouldDisableDefaultReportUri) throws MalformedURLException {
        DomainValidator domainValidator = DomainValidator.getInstance();
        if (!domainValidator.isValid(hostname)) {
            throw new ConfigurationException("Tried to pin an invalid domain: " + hostname);
        }
        this.hostname = hostname.trim();
        if (publicKeyHashStrList == null) {
            publicKeyHashStrList = new HashSet<String>();
        }
        this.shouldEnforcePinning = shouldEnforcePinning == null ? false : shouldEnforcePinning;
        this.shouldIncludeSubdomains = shouldIncludeSubdomains == null ? false : shouldIncludeSubdomains;
        if (publicKeyHashStrList.isEmpty() && this.shouldEnforcePinning) {
            throw new ConfigurationException("An empty pin-set was supplied for domain " + this.hostname + " with the enforcePinning set to true. An empty pin-set disables pinning and can't be use with enforcePinning set to true.");
        }
        if (publicKeyHashStrList.size() < 2 && this.shouldEnforcePinning) {
            throw new ConfigurationException("Less than two pins were supplied for domain " + this.hostname + ". This might brick your App; please review the Getting Started guide in ./docs/getting-started.md");
        }
        this.publicKeyPins = new HashSet<PublicKeyPin>();
        for (String pinStr : publicKeyHashStrList) {
            this.publicKeyPins.add(new PublicKeyPin(pinStr));
        }
        this.reportUris = new HashSet<URL>();
        if (reportUriStrList != null) {
            for (String UriStr : reportUriStrList) {
                this.reportUris.add(new URL(UriStr));
            }
        }
        if (shouldDisableDefaultReportUri == null || !shouldDisableDefaultReportUri.booleanValue()) {
            this.reportUris.add(DEFAULT_REPORTING_URL);
        }
        this.expirationDate = expirationDate;
    }

    @NonNull
    public String getHostname() {
        return this.hostname;
    }

    @NonNull
    public Set<PublicKeyPin> getPublicKeyPins() {
        return this.publicKeyPins;
    }

    public boolean shouldEnforcePinning() {
        return this.shouldEnforcePinning;
    }

    @NonNull
    public Set<URL> getReportUris() {
        return this.reportUris;
    }

    public boolean shouldIncludeSubdomains() {
        return this.shouldIncludeSubdomains;
    }

    @Nullable
    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public String toString() {
        return "DomainPinningPolicy{hostname = " + this.hostname + "\nknownPins = " + Arrays.toString(this.publicKeyPins.toArray()) + "\nshouldEnforcePinning = " + this.shouldEnforcePinning + "\nreportUris = " + this.reportUris + "\nshouldIncludeSubdomains = " + this.shouldIncludeSubdomains + "\n}";
    }

    static {
        URL defaultUrl;
        try {
            defaultUrl = new URL("https://overmind.datatheorem.com/trustkit/report");
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Bad DEFAULT_REPORTING_URL");
        }
        DEFAULT_REPORTING_URL = defaultUrl;
    }

    public static final class Builder {
        private String hostname;
        private Boolean shouldIncludeSubdomains;
        private Set<String> publicKeyHashes;
        private Date expirationDate;
        private Boolean shouldEnforcePinning;
        private Set<String> reportUris;
        private Boolean shouldDisableDefaultReportUri;
        private Builder parentBuilder = null;

        @Nullable
        public DomainPinningPolicy build() throws MalformedURLException {
            if (this.parentBuilder != null) {
                if (this.shouldIncludeSubdomains == null) {
                    this.shouldIncludeSubdomains = this.parentBuilder.getShouldIncludeSubdomains();
                }
                if (this.publicKeyHashes == null) {
                    this.publicKeyHashes = this.parentBuilder.getPublicKeyHashes();
                }
                if (this.expirationDate == null) {
                    this.expirationDate = this.parentBuilder.getExpirationDate();
                }
                if (this.shouldEnforcePinning == null) {
                    this.shouldEnforcePinning = this.parentBuilder.getShouldEnforcePinning();
                }
                if (this.reportUris == null) {
                    this.reportUris = this.parentBuilder.getReportUris();
                }
                if (this.shouldDisableDefaultReportUri == null) {
                    this.shouldDisableDefaultReportUri = this.parentBuilder.getShouldDisableDefaultReportUri();
                }
            }
            if (this.publicKeyHashes == null) {
                return null;
            }
            return new DomainPinningPolicy(this.hostname, this.shouldIncludeSubdomains, this.publicKeyHashes, this.shouldEnforcePinning, this.expirationDate, this.reportUris, this.shouldDisableDefaultReportUri);
        }

        public Builder setParent(Builder parent) {
            Builder current = parent;
            while (current != null) {
                if (current == this) {
                    throw new IllegalArgumentException("Loops are not allowed in Builder parents");
                }
                current = current.parentBuilder;
            }
            this.parentBuilder = parent;
            return this;
        }

        public Builder setHostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        Boolean getShouldIncludeSubdomains() {
            return this.shouldIncludeSubdomains;
        }

        public Builder setShouldIncludeSubdomains(Boolean shouldIncludeSubdomains) {
            this.shouldIncludeSubdomains = shouldIncludeSubdomains;
            return this;
        }

        Set<String> getPublicKeyHashes() {
            return this.publicKeyHashes;
        }

        public Builder setPublicKeyHashes(Set<String> publicKeyHashes) {
            this.publicKeyHashes = publicKeyHashes;
            return this;
        }

        Date getExpirationDate() {
            return this.expirationDate;
        }

        public Builder setExpirationDate(Date expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        Boolean getShouldEnforcePinning() {
            return this.shouldEnforcePinning;
        }

        public Builder setShouldEnforcePinning(Boolean shouldEnforcePinning) {
            this.shouldEnforcePinning = shouldEnforcePinning;
            return this;
        }

        Set<String> getReportUris() {
            return this.reportUris;
        }

        public Builder setReportUris(Set<String> reportUris) {
            this.reportUris = reportUris;
            return this;
        }

        Boolean getShouldDisableDefaultReportUri() {
            return this.shouldDisableDefaultReportUri;
        }

        public Builder setShouldDisableDefaultReportUri(Boolean shouldDisableDefaultReportUri) {
            this.shouldDisableDefaultReportUri = shouldDisableDefaultReportUri;
            return this;
        }
    }
}

