/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.data.domain.query;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.stargate.sdk.data.domain.query.DeleteQueryBuilder;
import java.util.Map;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DeleteQuery {
    private Map<String, Object> sort;
    private Map<String, Object> filter;

    public DeleteQuery() {
    }

    public static DeleteQueryBuilder builder() {
        return new DeleteQueryBuilder();
    }

    public DeleteQuery(DeleteQueryBuilder builder) {
        this.filter = builder.filter;
        this.sort = builder.sort;
    }

    public static DeleteQuery deleteById(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return DeleteQuery.builder().where("_id").isEqualsTo(id).build();
    }

    public static DeleteQuery deleteByVector(@NonNull float[] embeddings) {
        if (embeddings == null) {
            throw new NullPointerException("embeddings is marked non-null but is null");
        }
        return DeleteQuery.builder().orderByAnn(embeddings).build();
    }

    public Map<String, Object> getSort() {
        return this.sort;
    }

    public Map<String, Object> getFilter() {
        return this.filter;
    }
}

