/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.server.token;

import com.datastax.oss.simulacron.common.cluster.NodeSpec;
import com.datastax.oss.simulacron.server.token.TokenAssigner;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class RandomTokenAssigner
extends TokenAssigner {
    private static final Random random = new Random();
    private final int numberOfTokens;
    private final Set<Long> usedLongs = new TreeSet<Long>();

    public RandomTokenAssigner(int tokens) {
        this.numberOfTokens = tokens;
    }

    @Override
    public String getTokensInternal(NodeSpec nodeSpec) {
        TreeSet generatedTokens = new TreeSet();
        while (generatedTokens.size() < this.numberOfTokens) {
            generatedTokens.addAll(random.longs(this.numberOfTokens - generatedTokens.size()).filter(l -> !generatedTokens.contains(l) && !this.usedLongs.contains(l)).mapToObj(Long::new).collect(Collectors.toSet()));
        }
        this.usedLongs.addAll(generatedTokens);
        return generatedTokens.stream().map(Object::toString).collect(Collectors.joining(","));
    }
}

