/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.server;

import com.datastax.oss.simulacron.server.AddressResolver;
import com.datastax.oss.simulacron.server.InetSocketAddressComparator;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Inet4Resolver
implements AddressResolver {
    private static final Logger logger = LoggerFactory.getLogger(Inet4Resolver.class);
    private final AtomicReference<byte[]> ipParts;
    private static final AtomicBoolean WARNED = new AtomicBoolean();
    private final int port;
    private final Queue<InetSocketAddress> releasedAddresses = new PriorityBlockingQueue<InetSocketAddress>(10, InetSocketAddressComparator.INSTANCE);

    public Inet4Resolver(byte[] startingAddress) {
        this(startingAddress, 9042);
    }

    public Inet4Resolver() {
        this(defaultStartingIp, 9042);
    }

    public Inet4Resolver(int port) {
        this(defaultStartingIp, port);
    }

    public Inet4Resolver(byte[] startingAddress, int port) {
        byte[] ipAddr = new byte[4];
        System.arraycopy(startingAddress, 0, ipAddr, 0, 4);
        this.ipParts = new AtomicReference<byte[]>(ipAddr);
        this.port = port;
        Inet4Resolver.checkAddressPresence(ipAddr, 100);
    }

    public static void checkAddressPresence(byte[] ipBytes, int numberAddresses) {
        if (WARNED.get()) {
            return;
        }
        String osName = System.getProperty("os.name", "none");
        if (!osName.toLowerCase().startsWith("mac")) {
            return;
        }
        for (int i = 0; i < numberAddresses; ++i) {
            InetAddress inetAddress = Inet4Resolver.inetAddress(ipBytes);
            try {
                new ServerSocket(0, 0, inetAddress);
            }
            catch (IOException e) {
                if (WARNED.compareAndSet(false, true)) {
                    logger.warn("Detected that {} is not available for use.  Refer to https://goo.gl/Ru7gUj for information on how to provision IPs on OS X.", (Object)inetAddress);
                }
                return;
            }
            ipBytes = Inet4Resolver.nextAddressBytes(ipBytes);
        }
    }

    public static InetAddress inetAddress(byte[] ipBytes) {
        InetAddress addr;
        byte[] ipAddr = new byte[4];
        System.arraycopy(ipBytes, 0, ipAddr, 0, 4);
        try {
            addr = InetAddress.getByAddress(ipAddr);
        }
        catch (UnknownHostException uhe) {
            throw new IllegalArgumentException("Could not create ip address", uhe);
        }
        return addr;
    }

    public static byte[] nextAddressBytes(byte[] currentIpBytes) {
        byte[] newBytes = new byte[4];
        System.arraycopy(currentIpBytes, 0, newBytes, 0, 4);
        for (int i = currentIpBytes.length - 1; i > 0; --i) {
            if (newBytes[i] != -2) {
                int n = i;
                newBytes[n] = (byte)(newBytes[n] + 1);
                break;
            }
            newBytes[i] = 0;
        }
        return newBytes;
    }

    @Override
    public SocketAddress get() {
        InetAddress addr;
        byte[] next;
        byte[] ref;
        InetSocketAddress address = this.releasedAddresses.poll();
        if (address != null) {
            return address;
        }
        do {
            ref = this.ipParts.get();
            addr = Inet4Resolver.inetAddress(ref);
        } while (!this.ipParts.compareAndSet(ref, next = Inet4Resolver.nextAddressBytes(ref)));
        return new InetSocketAddress(addr, this.port);
    }

    @Override
    public void release(SocketAddress address) {
        this.releasedAddresses.offer((InetSocketAddress)address);
    }
}

