/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.server;

import com.datastax.oss.protocol.internal.Frame;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.response.Error;
import com.datastax.oss.simulacron.common.utils.FrameUtils;
import com.datastax.oss.simulacron.server.FrameCodecWrapper;
import com.datastax.oss.simulacron.server.UnsupportedProtocolVersionMessage;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrameDecoder
extends LengthFieldBasedFrameDecoder {
    private static final Logger logger = LoggerFactory.getLogger(FrameDecoder.class);
    private final FrameCodecWrapper frameCodec;
    private static final int MAX_FRAME_LENGTH = 0x10000000;
    private static final int HEADER_LENGTH = 5;
    private static final int LENGTH_FIELD_LENGTH = 4;
    private boolean isFirstResponse = true;

    FrameDecoder(FrameCodecWrapper frameCodec) {
        super(0x10000000, 5, 4, 0, 0, true);
        this.frameCodec = frameCodec;
    }

    protected Object decode(ChannelHandlerContext ctx, ByteBuf buffer) throws Exception {
        int startIndex = buffer.readerIndex();
        if (this.isFirstResponse) {
            if (buffer.readableBytes() < 8) {
                return null;
            }
            this.isFirstResponse = false;
            int protocolVersion = buffer.getByte(startIndex) & 0x7F;
            if (protocolVersion < 3) {
                byte streamId = buffer.getByte(startIndex + 2);
                int length = buffer.getInt(startIndex + 4);
                if (buffer.readableBytes() < 8 + length) {
                    return null;
                }
                buffer.readerIndex(startIndex + 8 + length);
                String message = "Invalid or unsupported protocol version";
                ByteBuf buf = ctx.alloc().buffer(14 + message.length());
                buf.writeByte(protocolVersion & 0x7F);
                buf.writeByte(0);
                buf.writeByte((int)streamId);
                buf.writeByte(0);
                buf.writeInt(6 + message.length());
                buf.writeInt(10);
                buf.writeShort(message.length());
                buf.writeBytes(message.getBytes("UTF-8"));
                ctx.writeAndFlush((Object)buf);
                return new UnsupportedProtocolVersionMessage(protocolVersion, streamId);
            }
        }
        if (buffer.readableBytes() < 5) {
            return null;
        }
        ByteBuf contents = (ByteBuf)super.decode(ctx, buffer);
        if (contents == null) {
            return null;
        }
        int protocolVersion = contents.getByte(contents.readerIndex()) & 0x7F;
        if (!this.frameCodec.getSupportedProtocolVersions().contains(protocolVersion)) {
            logger.warn("Received message with unsupported protocol version {}, sending back protocol error.", (Object)protocolVersion);
            short streamId = contents.getShort(contents.readerIndex() + 2);
            Error message = new Error(10, "Invalid or unsupported protocol version");
            Frame frame = new Frame(Collections.max(this.frameCodec.getSupportedProtocolVersions()).intValue(), false, (int)streamId, false, null, FrameUtils.emptyCustomPayload, Collections.emptyList(), (Message)message);
            ctx.writeAndFlush(this.frameCodec.encode(frame));
            int length = contents.getInt(contents.readerIndex() + 5);
            contents.skipBytes(9 + length);
            return new UnsupportedProtocolVersionMessage(protocolVersion, streamId);
        }
        return this.frameCodec.decode(contents);
    }

    protected ByteBuf extractFrame(ChannelHandlerContext ctx, ByteBuf buffer, int index, int length) {
        return buffer.slice(index, length);
    }
}

