/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.server;

import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class CompletableFutures {
    CompletableFutures() {
    }

    static <T> T getUninterruptibly(CompletionStage<T> stage) {
        boolean interrupted = false;
        while (true) {
            try {
                T t = stage.toCompletableFuture().get();
                return t;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            catch (ExecutionException e) {
                Throwable throwable = e.getCause();
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                throw new RuntimeException(throwable);
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    static <T> T getUninterruptibly(CompletionStage<T> stage, long time, TimeUnit timeUnit) {
        boolean interrupted = false;
        while (true) {
            try {
                T t = stage.toCompletableFuture().get(time, timeUnit);
                return t;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            catch (ExecutionException | TimeoutException e) {
                Throwable throwable = e.getCause();
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                throw new RuntimeException(throwable);
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

