/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.server;

import com.datastax.oss.simulacron.server.NodePerPortResolver;
import io.netty.channel.local.LocalAddress;
import java.net.SocketAddress;
import java.util.UUID;
import java.util.function.Supplier;

public interface AddressResolver
extends Supplier<SocketAddress> {
    public static final byte[] defaultStartingIp = new byte[]{127, 0, 0, 1};
    public static final int defaultStartingPort = 9042;
    public static final AddressResolver defaultResolver = new Inet4Resolver();
    public static final AddressResolver nodePerPortResolver = new NodePerPortResolver();
    public static final AddressResolver localAddressResolver = () -> new LocalAddress(UUID.randomUUID().toString());

    default public void release(SocketAddress address) {
    }

    @Deprecated
    public static class Inet4Resolver
    extends com.datastax.oss.simulacron.server.Inet4Resolver {
        public Inet4Resolver(byte[] startingAddress) {
            super(startingAddress, 9042);
        }

        public Inet4Resolver() {
        }

        public Inet4Resolver(int port) {
            super(port);
        }

        public Inet4Resolver(byte[] startingAddress, int port) {
            super(startingAddress, port);
        }
    }
}

