/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.request.query;

import com.datastax.oss.protocol.internal.PrimitiveCodec;
import java.util.EnumSet;

public enum QueryFlag {
    VALUES(1),
    SKIP_METADATA(2),
    PAGE_SIZE(4),
    PAGING_STATE(8),
    SERIAL_CONSISTENCY(16),
    DEFAULT_TIMESTAMP(32),
    VALUE_NAMES(64),
    WITH_KEYSPACE(128);

    private int mask;

    private QueryFlag(int mask) {
        this.mask = mask;
    }

    public static <B> EnumSet<QueryFlag> decode(B source, PrimitiveCodec<B> decoder, int protocolVersion) {
        int bits = protocolVersion >= 5 ? decoder.readInt(source) : (int)decoder.readByte(source);
        EnumSet<QueryFlag> set = EnumSet.noneOf(QueryFlag.class);
        for (QueryFlag flag : QueryFlag.values()) {
            if ((bits & flag.mask) == 0) continue;
            set.add(flag);
        }
        return set;
    }

    public static <B> void encode(EnumSet<QueryFlag> flags, B dest, PrimitiveCodec<B> encoder, int protocolVersion) {
        int bits = 0;
        for (QueryFlag flag : flags) {
            bits |= flag.mask;
        }
        if (protocolVersion >= 5) {
            encoder.writeInt(bits, dest);
        } else {
            encoder.writeByte((byte)bits, dest);
        }
    }

    public static int encodedSize(int protocolVersion) {
        return protocolVersion >= 5 ? 4 : 1;
    }
}

