/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal;

import java.nio.ByteBuffer;

public class ProtocolConstants {
    public static final ByteBuffer UNSET_VALUE = ByteBuffer.allocate(0);

    public static class BatchType {
        public static final byte LOGGED = 0;
        public static final byte UNLOGGED = 1;
        public static final byte COUNTER = 2;
    }

    public static class StatusChangeType {
        public static final String UP = "UP";
        public static final String DOWN = "DOWN";
    }

    public static class TopologyChangeType {
        public static final String NEW_NODE = "NEW_NODE";
        public static final String REMOVED_NODE = "REMOVED_NODE";
    }

    public static class SchemaChangeTarget {
        public static final String KEYSPACE = "KEYSPACE";
        public static final String TABLE = "TABLE";
        public static final String TYPE = "TYPE";
        public static final String FUNCTION = "FUNCTION";
        public static final String AGGREGATE = "AGGREGATE";
    }

    public static class SchemaChangeType {
        public static final String CREATED = "CREATED";
        public static final String UPDATED = "UPDATED";
        public static final String DROPPED = "DROPPED";
    }

    public static class EventType {
        public static final String TOPOLOGY_CHANGE = "TOPOLOGY_CHANGE";
        public static final String STATUS_CHANGE = "STATUS_CHANGE";
        public static final String SCHEMA_CHANGE = "SCHEMA_CHANGE";
    }

    public static class DataType {
        public static final int CUSTOM = 0;
        public static final int ASCII = 1;
        public static final int BIGINT = 2;
        public static final int BLOB = 3;
        public static final int BOOLEAN = 4;
        public static final int COUNTER = 5;
        public static final int DECIMAL = 6;
        public static final int DOUBLE = 7;
        public static final int FLOAT = 8;
        public static final int INT = 9;
        public static final int TIMESTAMP = 11;
        public static final int UUID = 12;
        public static final int VARCHAR = 13;
        public static final int VARINT = 14;
        public static final int TIMEUUID = 15;
        public static final int INET = 16;
        public static final int DATE = 17;
        public static final int TIME = 18;
        public static final int SMALLINT = 19;
        public static final int TINYINT = 20;
        public static final int DURATION = 21;
        public static final int LIST = 32;
        public static final int MAP = 33;
        public static final int SET = 34;
        public static final int UDT = 48;
        public static final int TUPLE = 49;
    }

    public static class WriteType {
        public static final String SIMPLE = "SIMPLE";
        public static final String BATCH = "BATCH";
        public static final String UNLOGGED_BATCH = "UNLOGGED_BATCH";
        public static final String COUNTER = "COUNTER";
        public static final String BATCH_LOG = "BATCH_LOG";
        public static final String VIEW = "VIEW";
        public static final String CDC = "CDC";
    }

    public static class ConsistencyLevel {
        public static final int ANY = 0;
        public static final int ONE = 1;
        public static final int TWO = 2;
        public static final int THREE = 3;
        public static final int QUORUM = 4;
        public static final int ALL = 5;
        public static final int LOCAL_QUORUM = 6;
        public static final int EACH_QUORUM = 7;
        public static final int SERIAL = 8;
        public static final int LOCAL_SERIAL = 9;
        public static final int LOCAL_ONE = 10;
    }

    public static class ErrorCode {
        public static final int SERVER_ERROR = 0;
        public static final int PROTOCOL_ERROR = 10;
        public static final int AUTH_ERROR = 256;
        public static final int UNAVAILABLE = 4096;
        public static final int OVERLOADED = 4097;
        public static final int IS_BOOTSTRAPPING = 4098;
        public static final int TRUNCATE_ERROR = 4099;
        public static final int WRITE_TIMEOUT = 4352;
        public static final int READ_TIMEOUT = 4608;
        public static final int READ_FAILURE = 4864;
        public static final int FUNCTION_FAILURE = 5120;
        public static final int WRITE_FAILURE = 5376;
        public static final int SYNTAX_ERROR = 8192;
        public static final int UNAUTHORIZED = 8448;
        public static final int INVALID = 8704;
        public static final int CONFIG_ERROR = 8960;
        public static final int ALREADY_EXISTS = 9216;
        public static final int UNPREPARED = 9472;
    }

    public static class ResultKind {
        public static final int VOID = 1;
        public static final int ROWS = 2;
        public static final int SET_KEYSPACE = 3;
        public static final int PREPARED = 4;
        public static final int SCHEMA_CHANGE = 5;
    }

    public static class Opcode {
        public static final int ERROR = 0;
        public static final int STARTUP = 1;
        public static final int READY = 2;
        public static final int AUTHENTICATE = 3;
        public static final int OPTIONS = 5;
        public static final int SUPPORTED = 6;
        public static final int QUERY = 7;
        public static final int RESULT = 8;
        public static final int PREPARE = 9;
        public static final int EXECUTE = 10;
        public static final int REGISTER = 11;
        public static final int EVENT = 12;
        public static final int BATCH = 13;
        public static final int AUTH_CHALLENGE = 14;
        public static final int AUTH_RESPONSE = 15;
        public static final int AUTH_SUCCESS = 16;
    }

    public static class Version {
        public static final int V3 = 3;
        public static final int V4 = 4;
        public static final int V5 = 5;
        public static final int MIN = 3;
        public static final int MAX = 4;
        public static final int BETA = 5;
    }
}

