/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.metrics.micrometer;

import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metrics.AbstractMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.MetricId;
import com.datastax.oss.driver.internal.metrics.micrometer.MicrometerTags;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public abstract class MicrometerMetricUpdater<MetricT>
extends AbstractMetricUpdater<MetricT> {
    protected final MeterRegistry registry;
    protected final ConcurrentMap<MetricT, Meter> metrics = new ConcurrentHashMap<MetricT, Meter>();

    protected MicrometerMetricUpdater(InternalDriverContext context, Set<MetricT> enabledMetrics, MeterRegistry registry) {
        super(context, enabledMetrics);
        this.registry = registry;
    }

    public void incrementCounter(MetricT metric, @Nullable String profileName, long amount) {
        if (this.isEnabled(metric, profileName)) {
            this.getOrCreateCounterFor(metric).increment((double)amount);
        }
    }

    public void updateHistogram(MetricT metric, @Nullable String profileName, long value) {
        if (this.isEnabled(metric, profileName)) {
            this.getOrCreateDistributionSummaryFor(metric).record((double)value);
        }
    }

    public void markMeter(MetricT metric, @Nullable String profileName, long amount) {
        if (this.isEnabled(metric, profileName)) {
            this.getOrCreateCounterFor(metric).increment((double)amount);
        }
    }

    public void updateTimer(MetricT metric, @Nullable String profileName, long duration, TimeUnit unit) {
        if (this.isEnabled(metric, profileName)) {
            this.getOrCreateTimerFor(metric).record(duration, unit);
        }
    }

    protected void clearMetrics() {
        for (Meter metric : this.metrics.values()) {
            this.registry.remove(metric);
        }
        this.metrics.clear();
    }

    protected abstract MetricId getMetricId(MetricT var1);

    protected void initializeGauge(MetricT metric, DriverExecutionProfile profile, Supplier<Number> supplier) {
        if (this.isEnabled(metric, profile.getName())) {
            this.metrics.computeIfAbsent(metric, m -> {
                MetricId id = this.getMetricId(m);
                Iterable<Tag> tags = MicrometerTags.toMicrometerTags(id.getTags());
                return Gauge.builder((String)id.getName(), (Supplier)supplier).tags(tags).register(this.registry);
            });
        }
    }

    protected void initializeCounter(MetricT metric, DriverExecutionProfile profile) {
        if (this.isEnabled(metric, profile.getName())) {
            this.getOrCreateCounterFor(metric);
        }
    }

    protected void initializeTimer(MetricT metric, DriverExecutionProfile profile) {
        if (this.isEnabled(metric, profile.getName())) {
            this.getOrCreateTimerFor(metric);
        }
    }

    protected Counter getOrCreateCounterFor(MetricT metric) {
        return (Counter)this.metrics.computeIfAbsent(metric, m -> {
            MetricId id = this.getMetricId(m);
            Iterable<Tag> tags = MicrometerTags.toMicrometerTags(id.getTags());
            return Counter.builder((String)id.getName()).tags(tags).register(this.registry);
        });
    }

    protected DistributionSummary getOrCreateDistributionSummaryFor(MetricT metric) {
        return (DistributionSummary)this.metrics.computeIfAbsent(metric, m -> {
            MetricId id = this.getMetricId(m);
            Iterable<Tag> tags = MicrometerTags.toMicrometerTags(id.getTags());
            DistributionSummary.Builder builder = DistributionSummary.builder((String)id.getName()).tags(tags);
            builder = this.configureDistributionSummary(builder, metric, id);
            return builder.register(this.registry);
        });
    }

    protected Timer getOrCreateTimerFor(MetricT metric) {
        return (Timer)this.metrics.computeIfAbsent(metric, m -> {
            MetricId id = this.getMetricId(m);
            Iterable<Tag> tags = MicrometerTags.toMicrometerTags(id.getTags());
            Timer.Builder builder = Timer.builder((String)id.getName()).tags(tags);
            builder = this.configureTimer(builder, metric, id);
            return builder.register(this.registry);
        });
    }

    protected Timer.Builder configureTimer(Timer.Builder builder, MetricT metric, MetricId id) {
        return builder.publishPercentileHistogram();
    }

    protected DistributionSummary.Builder configureDistributionSummary(DistributionSummary.Builder builder, MetricT metric, MetricId id) {
        return builder.publishPercentileHistogram();
    }
}

