/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.dao;

import com.datastax.dse.driver.api.core.cql.reactive.ReactiveResultSet;
import com.datastax.dse.driver.api.mapper.reactive.MappedReactiveResultSet;
import com.datastax.oss.driver.api.core.MappedAsyncPagingIterable;
import com.datastax.oss.driver.api.core.PagingIterable;
import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.internal.mapper.processor.ProcessorContext;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoReturnType;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoReturnTypeKind;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoReturnTypeParser;
import com.datastax.oss.driver.internal.mapper.processor.dao.DefaultDaoReturnTypeKind;
import com.datastax.oss.driver.internal.mapper.processor.dao.EntityUtils;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;

public class DefaultDaoReturnTypeParser
implements DaoReturnTypeParser {
    protected static final Map<TypeKind, DaoReturnType> DEFAULT_TYPE_KIND_MATCHES = ImmutableMap.builder().put((Object)TypeKind.VOID, (Object)DaoReturnType.VOID).put((Object)TypeKind.BOOLEAN, (Object)DaoReturnType.BOOLEAN).put((Object)TypeKind.LONG, (Object)DaoReturnType.LONG).build();
    protected static final Map<Class<?>, DaoReturnType> DEFAULT_CLASS_MATCHES = ImmutableMap.builder().put(Boolean.class, (Object)DaoReturnType.BOOLEAN).put(Long.class, (Object)DaoReturnType.LONG).put(Row.class, (Object)DaoReturnType.ROW).put(ResultSet.class, (Object)DaoReturnType.RESULT_SET).put(BoundStatement.class, (Object)DaoReturnType.BOUND_STATEMENT).put(ReactiveResultSet.class, (Object)DaoReturnType.REACTIVE_RESULT_SET).build();
    protected static final Map<Class<?>, DaoReturnTypeKind> DEFAULT_ENTITY_CONTAINER_MATCHES = ImmutableMap.builder().put(Optional.class, (Object)DefaultDaoReturnTypeKind.OPTIONAL_ENTITY).put(CompletionStage.class, (Object)DefaultDaoReturnTypeKind.FUTURE_OF_ENTITY).put(CompletableFuture.class, (Object)DefaultDaoReturnTypeKind.FUTURE_OF_ENTITY).put(PagingIterable.class, (Object)DefaultDaoReturnTypeKind.PAGING_ITERABLE).put(MappedReactiveResultSet.class, (Object)DefaultDaoReturnTypeKind.MAPPED_REACTIVE_RESULT_SET).build();
    protected static final Map<Class<?>, DaoReturnType> DEFAULT_FUTURE_OF_CLASS_MATCHES = ImmutableMap.builder().put(Void.class, (Object)DaoReturnType.FUTURE_OF_VOID).put(Boolean.class, (Object)DaoReturnType.FUTURE_OF_BOOLEAN).put(Long.class, (Object)DaoReturnType.FUTURE_OF_LONG).put(Row.class, (Object)DaoReturnType.FUTURE_OF_ROW).put(AsyncResultSet.class, (Object)DaoReturnType.FUTURE_OF_ASYNC_RESULT_SET).build();
    protected static final Map<Class<?>, DaoReturnTypeKind> DEFAULT_FUTURE_OF_ENTITY_CONTAINER_MATCHES = ImmutableMap.builder().put(Optional.class, (Object)DefaultDaoReturnTypeKind.FUTURE_OF_OPTIONAL_ENTITY).put(MappedAsyncPagingIterable.class, (Object)DefaultDaoReturnTypeKind.FUTURE_OF_ASYNC_PAGING_ITERABLE).build();
    protected final ProcessorContext context;
    private final Map<TypeKind, DaoReturnType> typeKindMatches;
    private final Map<Class<?>, DaoReturnType> classMatches;
    private final Map<Class<?>, DaoReturnTypeKind> entityContainerMatches;
    private final Map<Class<?>, DaoReturnType> futureOfClassMatches;
    private final Map<Class<?>, DaoReturnTypeKind> futureOfEntityContainerMatches;

    public DefaultDaoReturnTypeParser(ProcessorContext context) {
        this(context, DEFAULT_TYPE_KIND_MATCHES, DEFAULT_CLASS_MATCHES, DEFAULT_ENTITY_CONTAINER_MATCHES, DEFAULT_FUTURE_OF_CLASS_MATCHES, DEFAULT_FUTURE_OF_ENTITY_CONTAINER_MATCHES);
    }

    protected DefaultDaoReturnTypeParser(ProcessorContext context, Map<TypeKind, DaoReturnType> typeKindMatches, Map<Class<?>, DaoReturnType> classMatches, Map<Class<?>, DaoReturnTypeKind> entityContainerMatches, Map<Class<?>, DaoReturnType> futureOfClassMatches, Map<Class<?>, DaoReturnTypeKind> futureOfEntityContainerMatches) {
        this.context = context;
        this.typeKindMatches = typeKindMatches;
        this.classMatches = classMatches;
        this.entityContainerMatches = entityContainerMatches;
        this.futureOfClassMatches = futureOfClassMatches;
        this.futureOfEntityContainerMatches = futureOfEntityContainerMatches;
    }

    @Override
    @NonNull
    public DaoReturnType parse(@NonNull TypeMirror returnTypeMirror, @NonNull Map<Name, TypeElement> typeParameters) {
        TypeElement entityElement;
        DaoReturnType match = this.typeKindMatches.get((Object)returnTypeMirror.getKind());
        if (match != null) {
            return match;
        }
        if (returnTypeMirror.getKind() == TypeKind.DECLARED) {
            entityElement = EntityUtils.asEntityElement(returnTypeMirror, typeParameters);
            if (entityElement != null) {
                return new DaoReturnType(DefaultDaoReturnTypeKind.ENTITY, entityElement);
            }
            DeclaredType declaredReturnType = (DeclaredType)returnTypeMirror;
            for (Map.Entry<Class<?>, DaoReturnType> entry : this.classMatches.entrySet()) {
                Class<?> clazz = entry.getKey();
                if (!this.context.getClassUtils().isSame(declaredReturnType, clazz)) continue;
                return entry.getValue();
            }
            if (declaredReturnType.getTypeArguments().size() == 1 && (entityElement = EntityUtils.typeArgumentAsEntityElement(returnTypeMirror, typeParameters)) != null) {
                Element returnElement = declaredReturnType.asElement();
                for (Map.Entry<Class<?>, DaoReturnTypeKind> entry : this.entityContainerMatches.entrySet()) {
                    Class<?> containerClass = entry.getKey();
                    if (!this.context.getClassUtils().isSame(returnElement, containerClass)) continue;
                    return new DaoReturnType(entry.getValue(), entityElement);
                }
            }
            if (this.context.getClassUtils().isFuture(declaredReturnType)) {
                DeclaredType declaredType;
                TypeMirror typeArgumentMirror = declaredReturnType.getTypeArguments().get(0);
                for (Map.Entry<Class<?>, DaoReturnType> entry : this.futureOfClassMatches.entrySet()) {
                    Class<?> simpleClassArgument = entry.getKey();
                    if (!this.context.getClassUtils().isSame(typeArgumentMirror, simpleClassArgument)) continue;
                    return entry.getValue();
                }
                if (typeArgumentMirror.getKind() == TypeKind.DECLARED && (declaredType = (DeclaredType)typeArgumentMirror).getTypeArguments().size() == 1 && (entityElement = EntityUtils.typeArgumentAsEntityElement(typeArgumentMirror, typeParameters)) != null) {
                    Element element = declaredType.asElement();
                    for (Map.Entry entry : this.futureOfEntityContainerMatches.entrySet()) {
                        Class containerClass = (Class)entry.getKey();
                        if (!this.context.getClassUtils().isSame(element, containerClass)) continue;
                        return new DaoReturnType((DaoReturnTypeKind)entry.getValue(), entityElement);
                    }
                }
            }
        }
        if (returnTypeMirror.getKind() == TypeKind.TYPEVAR) {
            entityElement = EntityUtils.asEntityElement(returnTypeMirror, typeParameters);
            if (entityElement != null) {
                return new DaoReturnType(DefaultDaoReturnTypeKind.ENTITY, entityElement);
            }
            TypeVariable typeVariable = (TypeVariable)returnTypeMirror;
            Name name = typeVariable.asElement().getSimpleName();
            TypeElement typeElement = typeParameters.get(name);
            if (typeElement != null) {
                for (Map.Entry<Class<?>, DaoReturnType> entry : this.classMatches.entrySet()) {
                    Class<?> clazz = entry.getKey();
                    if (!this.context.getClassUtils().isSame(typeElement, clazz)) continue;
                    return entry.getValue();
                }
            }
        }
        return DaoReturnType.UNSUPPORTED;
    }
}

