/*
 * Copyright DataStax, Inc.
 *
 * This software can be used solely with DataStax Enterprise. Please consult the license at
 * http://www.datastax.com/terms/datastax-dse-driver-license-terms
 */
package com.datastax.driver.mapping;

import java.lang.reflect.Constructor;

/** Utility methods related to reflection. */
class ReflectionUtils {

  static <T> T newInstance(Class<T> clazz) {
    Constructor<T> publicConstructor;
    try {
      publicConstructor = clazz.getConstructor();
    } catch (NoSuchMethodException e) {
      try {
        // try private constructor
        Constructor<T> privateConstructor = clazz.getDeclaredConstructor();
        privateConstructor.setAccessible(true);
        return privateConstructor.newInstance();
      } catch (Exception e1) {
        throw new IllegalArgumentException("Can't create an instance of " + clazz, e);
      }
    }
    try {
      return publicConstructor.newInstance();
    } catch (Exception e) {
      throw new IllegalArgumentException("Can't create an instance of " + clazz, e);
    }
  }
}
