/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.mapping;

import com.datastax.driver.mapping.NamingConvention;
import com.datastax.driver.mapping.Word;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

public class NamingConventions {
    public static final NamingConvention LOWER_CASE = new SingleWordNamingConvention(false);
    public static final NamingConvention UPPER_CASE = new SingleWordNamingConvention(true);
    public static final NamingConvention LOWER_SNAKE_CASE = new CharDelimitedNamingConvention("_", false);
    public static final NamingConvention UPPER_SNAKE_CASE = new CharDelimitedNamingConvention("_", true);
    public static final NamingConvention LOWER_LISP_CASE = new CharDelimitedNamingConvention("-", false);
    public static final NamingConvention UPPER_LISP_CASE = new CharDelimitedNamingConvention("-", true);
    public static final NamingConvention LOWER_CAMEL_CASE = new LowerCamelCase(new String[0]);
    public static final NamingConvention UPPER_CAMEL_CASE = new UpperCamelCase(new String[0]);

    public static class SingleWordNamingConvention
    implements NamingConvention {
        private final boolean isUpperCase;

        protected SingleWordNamingConvention(boolean isUpperCase) {
            this.isUpperCase = isUpperCase;
        }

        @Override
        public List<Word> split(String input) {
            LinkedList<Word> result = new LinkedList<Word>();
            result.add(new Word(input));
            return result;
        }

        @Override
        public String join(List<Word> input) {
            StringBuilder builder = new StringBuilder();
            for (Word word : input) {
                builder.append(word.getValue());
            }
            String result = builder.toString();
            return this.isUpperCase ? result.toUpperCase() : result.toLowerCase();
        }
    }

    public static class CharDelimitedNamingConvention
    implements NamingConvention {
        private final String delimiter;
        private final boolean isUpperCase;

        protected CharDelimitedNamingConvention(String delimiter, boolean isUpperCase) {
            this.delimiter = delimiter;
            this.isUpperCase = isUpperCase;
        }

        @Override
        public List<Word> split(String input) {
            LinkedList<Word> result = new LinkedList<Word>();
            for (String value : input.split(this.delimiter)) {
                result.add(new Word(value));
            }
            return result;
        }

        @Override
        public String join(List<Word> input) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < input.size(); ++i) {
                if (i > 0) {
                    builder.append(this.delimiter);
                }
                builder.append(input.get(i).getValue());
            }
            String result = builder.toString();
            return this.isUpperCase ? result.toUpperCase() : result.toLowerCase();
        }
    }

    public static abstract class CamelCase
    implements NamingConvention {
        private static final Pattern SPLIT_PATTERN = Pattern.compile(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"));
        private static final Pattern ALL_UPPERCASE_PATTERN = Pattern.compile("([A-Z])*");
        private static final Comparator<String> STRING_LENGTH_COMPARATOR = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.length() - o1.length();
            }
        };
        private final Pattern ignorablePrefixPattern;

        protected CamelCase(String ... ignorablePrefixes) {
            Arrays.sort(ignorablePrefixes, STRING_LENGTH_COMPARATOR);
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < ignorablePrefixes.length; ++i) {
                if (i > 0) {
                    builder.append("|");
                }
                builder.append("^");
                builder.append(ignorablePrefixes[i]);
            }
            this.ignorablePrefixPattern = Pattern.compile(builder.toString());
        }

        @Override
        public List<Word> split(String input) {
            LinkedList<Word> result = new LinkedList<Word>();
            for (String value : SPLIT_PATTERN.split(this.ignorablePrefixPattern.matcher(input).replaceAll(""))) {
                boolean isAbbreviation = ALL_UPPERCASE_PATTERN.matcher(value).matches();
                Word word = new Word(value, isAbbreviation);
                result.add(word);
            }
            return result;
        }
    }

    public static class UpperCamelCase
    extends CamelCase {
        private final boolean upperCaseAbbreviations;

        public UpperCamelCase(boolean upperCaseAbbreviations, String ... ignorablePrefixes) {
            super(ignorablePrefixes);
            this.upperCaseAbbreviations = upperCaseAbbreviations;
        }

        public UpperCamelCase(String ... ignorablePrefixes) {
            this(false, ignorablePrefixes);
        }

        public UpperCamelCase(boolean upperCaseAbbreviations) {
            this(upperCaseAbbreviations, new String[0]);
        }

        @Override
        public String join(List<Word> input) {
            StringBuilder builder = new StringBuilder();
            for (Word word : input) {
                String value = this.upperCaseAbbreviations && word.isAbbreviation() ? word.getValue().toUpperCase() : word.getValue().substring(0, 1).toUpperCase() + word.getValue().substring(1).toLowerCase();
                builder.append(value);
            }
            return builder.toString();
        }
    }

    public static class LowerCamelCase
    extends CamelCase {
        private final boolean upperCaseAbbreviations;

        public LowerCamelCase(boolean upperCaseAbbreviations, String ... ignorablePrefixes) {
            super(ignorablePrefixes);
            this.upperCaseAbbreviations = upperCaseAbbreviations;
        }

        public LowerCamelCase(String ... ignorablePrefixes) {
            this(false, ignorablePrefixes);
        }

        public LowerCamelCase(boolean upperCaseAbbreviations) {
            this(upperCaseAbbreviations, new String[0]);
        }

        @Override
        public String join(List<Word> input) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < input.size(); ++i) {
                Word word = input.get(i);
                String value = i == 0 ? word.getValue().toLowerCase() : (this.upperCaseAbbreviations && word.isAbbreviation() ? word.getValue().toUpperCase() : word.getValue().substring(0, 1).toUpperCase() + word.getValue().substring(1).toLowerCase());
                builder.append(value);
            }
            return builder.toString();
        }
    }
}

