/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.mapping;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.mapping.AliasedMappedProperty;
import com.datastax.driver.mapping.ReflectionUtils;
import java.util.ArrayList;
import java.util.List;

class EntityMapper<T> {
    private final Class<T> entityClass;
    final String keyspace;
    final String table;
    final ConsistencyLevel writeConsistency;
    final ConsistencyLevel readConsistency;
    final List<AliasedMappedProperty<?>> partitionKeys = new ArrayList();
    final List<AliasedMappedProperty<?>> clusteringColumns = new ArrayList();
    final List<AliasedMappedProperty<?>> allColumns = new ArrayList();

    EntityMapper(Class<T> entityClass, String keyspace, String table, ConsistencyLevel writeConsistency, ConsistencyLevel readConsistency) {
        this.entityClass = entityClass;
        this.keyspace = keyspace;
        this.table = table;
        this.writeConsistency = writeConsistency;
        this.readConsistency = readConsistency;
    }

    int primaryKeySize() {
        return this.partitionKeys.size() + this.clusteringColumns.size();
    }

    AliasedMappedProperty<?> getPrimaryKeyColumn(int i) {
        return i < this.partitionKeys.size() ? this.partitionKeys.get(i) : this.clusteringColumns.get(i - this.partitionKeys.size());
    }

    void addColumns(List<AliasedMappedProperty<?>> pks, List<AliasedMappedProperty<?>> ccs, List<AliasedMappedProperty<?>> rgs) {
        this.partitionKeys.addAll(pks);
        this.clusteringColumns.addAll(ccs);
        this.allColumns.addAll(pks);
        this.allColumns.addAll(ccs);
        this.allColumns.addAll(rgs);
    }

    T newEntity() {
        return ReflectionUtils.newInstance(this.entityClass);
    }
}

