/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.mapping;

import com.google.common.base.Throwables;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

class ReflectionUtils {
    ReflectionUtils() {
    }

    static <T> T newInstance(Class<T> clazz) {
        Constructor<T> publicConstructor;
        try {
            publicConstructor = clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                Constructor<T> privateConstructor = clazz.getDeclaredConstructor(new Class[0]);
                privateConstructor.setAccessible(true);
                return privateConstructor.newInstance(new Object[0]);
            }
            catch (Exception e1) {
                throw new IllegalArgumentException("Can't create an instance of " + clazz, e);
            }
        }
        try {
            return publicConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can't create an instance of " + clazz, e);
        }
    }

    static <T> Map<String, Object[]> scanFieldsAndProperties(Class<T> baseClass) {
        HashMap<String, Object[]> fieldsAndProperties = new HashMap<String, Object[]>();
        Map<String, Field> fields = ReflectionUtils.scanFields(baseClass);
        for (Map.Entry<String, Field> entry : fields.entrySet()) {
            fieldsAndProperties.put(entry.getKey(), new Object[]{entry.getValue(), null});
        }
        Map<String, PropertyDescriptor> properties = ReflectionUtils.scanProperties(baseClass);
        for (Map.Entry<String, PropertyDescriptor> entry : properties.entrySet()) {
            Object[] value = (Object[])fieldsAndProperties.get(entry.getKey());
            if (value == null) {
                fieldsAndProperties.put(entry.getKey(), new Object[]{null, entry.getValue()});
                continue;
            }
            value[1] = entry.getValue();
        }
        return fieldsAndProperties;
    }

    private static <T> Map<String, Field> scanFields(Class<T> baseClass) {
        HashMap<String, Field> fields = new HashMap<String, Field>();
        Class<T> clazz = baseClass;
        while (!clazz.equals(Object.class)) {
            for (Field field : clazz.getDeclaredFields()) {
                if (field.getName().equals("class") || field.isSynthetic() || Modifier.isStatic(field.getModifiers()) || fields.containsKey(field.getName())) continue;
                fields.put(field.getName(), field);
            }
            clazz = clazz.getSuperclass();
        }
        return fields;
    }

    private static <T> Map<String, PropertyDescriptor> scanProperties(Class<T> baseClass) {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(baseClass);
        }
        catch (IntrospectionException e) {
            throw Throwables.propagate((Throwable)e);
        }
        HashMap<String, PropertyDescriptor> properties = new HashMap<String, PropertyDescriptor>();
        for (PropertyDescriptor property : beanInfo.getPropertyDescriptors()) {
            if (property.getName().equals("class")) continue;
            properties.put(property.getName(), property);
        }
        return properties;
    }

    static Map<Class<? extends Annotation>, Annotation> scanPropertyAnnotations(Field field, PropertyDescriptor property) {
        Method getter;
        HashMap<Class<? extends Annotation>, Annotation> annotations = new HashMap<Class<? extends Annotation>, Annotation>();
        if (field != null) {
            ReflectionUtils.scanFieldAnnotations(field, annotations);
        }
        if ((getter = ReflectionUtils.findGetter(property)) != null) {
            ReflectionUtils.scanMethodAnnotations(getter, annotations);
        }
        return annotations;
    }

    private static Map<Class<? extends Annotation>, Annotation> scanFieldAnnotations(Field field, Map<Class<? extends Annotation>, Annotation> annotations) {
        for (Annotation annotation : field.getAnnotations()) {
            annotations.put(annotation.annotationType(), annotation);
        }
        return annotations;
    }

    private static Map<Class<? extends Annotation>, Annotation> scanMethodAnnotations(Method method, Map<Class<? extends Annotation>, Annotation> annotations) {
        for (Annotation annotation : method.getAnnotations()) {
            annotations.put(annotation.annotationType(), annotation);
        }
        Class<?> getterClass = method.getDeclaringClass();
        Class<?> clazz = getterClass.getSuperclass();
        while (!clazz.equals(Object.class)) {
            ReflectionUtils.maybeAddOverriddenMethodAnnotations(annotations, method, clazz);
            clazz = clazz.getSuperclass();
        }
        clazz = getterClass;
        while (!clazz.equals(Object.class)) {
            for (Class<?> itf : clazz.getInterfaces()) {
                ReflectionUtils.maybeAddOverriddenMethodAnnotations(annotations, method, itf);
            }
            clazz = clazz.getSuperclass();
        }
        return annotations;
    }

    private static void maybeAddOverriddenMethodAnnotations(Map<Class<? extends Annotation>, Annotation> annotations, Method getter, Class<?> clazz) {
        try {
            Method overriddenGetter = clazz.getDeclaredMethod(getter.getName(), getter.getParameterTypes());
            for (Annotation annotation : overriddenGetter.getAnnotations()) {
                if (annotations.containsKey(annotation.annotationType())) continue;
                annotations.put(annotation.annotationType(), annotation);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    static Method findGetter(PropertyDescriptor property) {
        if (property == null) {
            return null;
        }
        Method getter = property.getReadMethod();
        if (getter == null) {
            return null;
        }
        return getter;
    }

    static Method findSetter(Class<?> baseClass, PropertyDescriptor property) {
        if (property == null) {
            return null;
        }
        Method setter = property.getWriteMethod();
        if (setter != null) {
            return setter;
        }
        String propertyName = property.getName();
        String setterName = "set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        try {
            setter = baseClass.getMethod(setterName, property.getPropertyType());
            if (!Modifier.isStatic(setter.getModifiers())) {
                return setter;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    static void tryMakeAccessible(AccessibleObject object) {
        if (!object.isAccessible()) {
            try {
                object.setAccessible(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }
}

