/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.mapping;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.mapping.ColumnMapper;
import com.datastax.driver.mapping.MappingManager;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

abstract class EntityMapper<T> {
    public final Class<T> entityClass;
    private final String keyspace;
    private final String table;
    public final ConsistencyLevel writeConsistency;
    public final ConsistencyLevel readConsistency;
    public final List<ColumnMapper<T>> partitionKeys = new ArrayList<ColumnMapper<T>>();
    public final List<ColumnMapper<T>> clusteringColumns = new ArrayList<ColumnMapper<T>>();
    public final List<ColumnMapper<T>> regularColumns = new ArrayList<ColumnMapper<T>>();
    private final List<ColumnMapper<T>> allColumns = new ArrayList<ColumnMapper<T>>();

    protected EntityMapper(Class<T> entityClass, String keyspace, String table, ConsistencyLevel writeConsistency, ConsistencyLevel readConsistency) {
        this.entityClass = entityClass;
        this.keyspace = keyspace;
        this.table = table;
        this.writeConsistency = writeConsistency;
        this.readConsistency = readConsistency;
    }

    public String getKeyspace() {
        return QueryBuilder.quote((String)this.keyspace);
    }

    public String getTable() {
        return QueryBuilder.quote((String)this.table);
    }

    public int primaryKeySize() {
        return this.partitionKeys.size() + this.clusteringColumns.size();
    }

    public ColumnMapper<T> getPrimaryKeyColumn(int i) {
        return i < this.partitionKeys.size() ? this.partitionKeys.get(i) : this.clusteringColumns.get(i - this.partitionKeys.size());
    }

    public void addColumns(List<ColumnMapper<T>> pks, List<ColumnMapper<T>> ccs, List<ColumnMapper<T>> rgs) {
        this.partitionKeys.addAll(pks);
        this.allColumns.addAll(pks);
        this.clusteringColumns.addAll(ccs);
        this.allColumns.addAll(ccs);
        this.addColumns(rgs);
    }

    public void addColumns(List<ColumnMapper<T>> rgs) {
        this.regularColumns.addAll(rgs);
        this.allColumns.addAll(rgs);
    }

    public abstract T newEntity();

    public List<ColumnMapper<T>> allColumns() {
        return this.allColumns;
    }

    static interface Factory {
        public <T> EntityMapper<T> create(Class<T> var1, String var2, String var3, ConsistencyLevel var4, ConsistencyLevel var5);

        public <T> ColumnMapper<T> createColumnMapper(Class<T> var1, Field var2, int var3, MappingManager var4, AtomicInteger var5);
    }
}

