/*
 * Decompiled with CFR 0.152.
 */
package com.timgroup.statsd;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;

public abstract class Message
implements Comparable<Message> {
    final String aspect;
    final Type type;
    final String[] tags;
    protected boolean done;
    protected static final int HASH_MULTIPLIER = 31;
    protected static final Set<Type> AGGREGATE_SET = EnumSet.of(Type.COUNT, Type.GAUGE, Type.SET);

    protected Message(Type type) {
        this("", type, null);
    }

    protected Message(String aspect, Type type, String[] tags) {
        this.aspect = aspect == null ? "" : aspect;
        this.type = type;
        this.done = false;
        this.tags = tags;
    }

    abstract boolean writeTo(StringBuilder var1, int var2, String var3);

    public abstract void aggregate(Message var1);

    public final String getAspect() {
        return this.aspect;
    }

    public final Type getType() {
        return this.type;
    }

    public String[] getTags() {
        return this.tags;
    }

    public boolean canAggregate() {
        return AGGREGATE_SET.contains((Object)this.type);
    }

    public void setDone(boolean done) {
        this.done = done;
    }

    public boolean getDone() {
        return this.done;
    }

    public int hashCode() {
        return this.type.hashCode() * 31 * 31 + this.aspect.hashCode() * 31 + Arrays.hashCode(this.tags);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Message) {
            Message msg = (Message)object;
            return Objects.equals(this.getAspect(), msg.getAspect()) && this.getType() == msg.getType() && Arrays.equals(this.tags, msg.getTags());
        }
        return false;
    }

    @Override
    public int compareTo(Message message) {
        int typeComparison = this.getType().compareTo(message.getType());
        if (typeComparison == 0) {
            int aspectComparison = this.getAspect().compareTo(message.getAspect());
            if (aspectComparison == 0) {
                if (this.tags == null && message.tags == null) {
                    return 0;
                }
                if (this.tags == null) {
                    return 1;
                }
                if (message.tags == null) {
                    return -1;
                }
                if (this.tags.length == message.tags.length) {
                    int comparison = 0;
                    for (int i = 0; i < this.tags.length && comparison == 0; ++i) {
                        comparison = this.tags[i].compareTo(message.tags[i]);
                    }
                    return comparison;
                }
                return this.tags.length < message.tags.length ? 1 : -1;
            }
            return aspectComparison;
        }
        return typeComparison;
    }

    public static enum Type {
        GAUGE("g"),
        COUNT("c"),
        TIME("ms"),
        SET("s"),
        HISTOGRAM("h"),
        DISTRIBUTION("d"),
        EVENT("_e"),
        SERVICE_CHECK("_sc");

        private final String type;

        private Type(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

