/*
 * Decompiled with CFR 0.152.
 */
package com.timgroup.statsd;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class CgroupReader {
    private static final Path CGROUP_PATH = Paths.get("/proc/self/cgroup", new String[0]);
    private static final String CONTAINER_SOURCE = "[0-9a-f]{64}";
    private static final String TASK_SOURCE = "[0-9a-f]{32}-\\d+";
    private static final Pattern LINE_RE = Pattern.compile("^\\d+:[^:]*:(.+)$", 9);
    private static final Pattern CONTAINER_RE = Pattern.compile("([0-9a-f]{64}|[0-9a-f]{32}-\\d+)(?:.scope)?$");
    private boolean readOnce = false;
    public String containerID;

    CgroupReader() {
    }

    public String getContainerID() throws IOException {
        if (this.readOnce) {
            return this.containerID;
        }
        this.containerID = this.read(CGROUP_PATH);
        return this.containerID;
    }

    private String read(Path path) throws IOException {
        this.readOnce = true;
        if (!Files.isReadable(path)) {
            return null;
        }
        String content = new String(Files.readAllBytes(path));
        if (content.isEmpty()) {
            return null;
        }
        return CgroupReader.parse(content);
    }

    public static String parse(String cgroupsContent) {
        Matcher lines = LINE_RE.matcher(cgroupsContent);
        while (lines.find()) {
            String path = lines.group(1);
            Matcher matcher = CONTAINER_RE.matcher(path);
            if (!matcher.find()) continue;
            return matcher.group(1);
        }
        return null;
    }
}

