/*
 * Decompiled with CFR 0.152.
 */
package com.timgroup.statsd;

import com.timgroup.statsd.Event;
import com.timgroup.statsd.ServiceCheck;
import com.timgroup.statsd.StatsDClient;
import com.timgroup.statsd.StatsDClientErrorHandler;
import com.timgroup.statsd.StatsDClientException;
import com.timgroup.statsd.StatsDSender;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.DatagramChannel;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import jnr.unixsocket.UnixDatagramChannel;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketOptions;

public class NonBlockingStatsDClient
implements StatsDClient {
    public static final String DD_ENTITY_ID_ENV_VAR = "DD_ENTITY_ID";
    public static final String DD_DOGSTATSD_PORT_ENV_VAR = "DD_DOGSTATSD_PORT";
    public static final String DD_AGENT_HOST_ENV_VAR = "DD_AGENT_HOST";
    private static final int DEFAULT_MAX_PACKET_SIZE_BYTES = 1400;
    private static final int DEFAULT_DOGSTATSD_PORT = 8125;
    private static final int SOCKET_TIMEOUT_MS = 100;
    private static final int SOCKET_BUFFER_BYTES = -1;
    private static final StatsDClientErrorHandler NO_OP_HANDLER = new StatsDClientErrorHandler(){

        @Override
        public void handle(Exception e) {
        }
    };
    private static final ThreadLocal<NumberFormat> NUMBER_FORMATTERS = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            NumberFormat numberFormatter = NumberFormat.getInstance(Locale.US);
            numberFormatter.setGroupingUsed(false);
            numberFormatter.setMaximumFractionDigits(6);
            if (numberFormatter instanceof DecimalFormat) {
                DecimalFormat decimalFormat = (DecimalFormat)numberFormatter;
                DecimalFormatSymbols symbols = decimalFormat.getDecimalFormatSymbols();
                symbols.setNaN("NaN");
                decimalFormat.setDecimalFormatSymbols(symbols);
            }
            return numberFormatter;
        }
    };
    private static final ThreadLocal<NumberFormat> SAMPLE_RATE_FORMATTERS = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            NumberFormat numberFormatter = NumberFormat.getInstance(Locale.US);
            numberFormatter.setGroupingUsed(false);
            numberFormatter.setMinimumFractionDigits(6);
            if (numberFormatter instanceof DecimalFormat) {
                DecimalFormat decimalFormat = (DecimalFormat)numberFormatter;
                DecimalFormatSymbols symbols = decimalFormat.getDecimalFormatSymbols();
                symbols.setNaN("NaN");
                decimalFormat.setDecimalFormatSymbols(symbols);
            }
            return numberFormatter;
        }
    };
    private final String prefix;
    private final DatagramChannel clientChannel;
    private final StatsDClientErrorHandler handler;
    private final String constantTagsRendered;
    private final ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactory(){
        final ThreadFactory delegate = Executors.defaultThreadFactory();

        @Override
        public Thread newThread(Runnable r) {
            Thread result = this.delegate.newThread(r);
            result.setName("StatsD-" + result.getName());
            result.setDaemon(true);
            return result;
        }
    });
    private final StatsDSender statsDSender;
    private final String ENTITY_ID_TAG_NAME = "dd.internal.entity_id";

    public NonBlockingStatsDClient(String prefix) throws StatsDClientException {
        this(prefix, NonBlockingStatsDClient.getHostnameFromEnvVar(), NonBlockingStatsDClient.getPortFromEnvVar(8125), Integer.MAX_VALUE);
    }

    public NonBlockingStatsDClient(String prefix, String hostname, int port) throws StatsDClientException {
        this(prefix, hostname, port, Integer.MAX_VALUE);
    }

    public NonBlockingStatsDClient(String prefix, String hostname, int port, int queueSize) throws StatsDClientException {
        this(prefix, hostname, port, queueSize, (String[])null, (StatsDClientErrorHandler)null);
    }

    public NonBlockingStatsDClient(String prefix, String hostname, int port, String ... constantTags) throws StatsDClientException {
        this(prefix, hostname, port, Integer.MAX_VALUE, constantTags, (StatsDClientErrorHandler)null);
    }

    public NonBlockingStatsDClient(String prefix, String hostname, int port, String[] constantTags, int maxPacketSizeBytes) throws StatsDClientException {
        this(prefix, hostname, port, Integer.MAX_VALUE, constantTags, null, maxPacketSizeBytes);
    }

    public NonBlockingStatsDClient(String prefix, String hostname, int port, int queueSize, String ... constantTags) throws StatsDClientException {
        this(prefix, hostname, port, queueSize, constantTags, (StatsDClientErrorHandler)null);
    }

    public NonBlockingStatsDClient(String prefix, String hostname, int port, String[] constantTags, StatsDClientErrorHandler errorHandler) throws StatsDClientException {
        this(prefix, Integer.MAX_VALUE, constantTags, errorHandler, NonBlockingStatsDClient.staticStatsDAddressResolution(hostname, port), 100, -1, 1400, null);
    }

    public NonBlockingStatsDClient(String prefix, String hostname, int port, int queueSize, String[] constantTags, StatsDClientErrorHandler errorHandler) throws StatsDClientException {
        this(prefix, queueSize, constantTags, errorHandler, NonBlockingStatsDClient.staticStatsDAddressResolution(hostname, port), 100, -1, 1400, null);
    }

    public NonBlockingStatsDClient(String prefix, String hostname, int port, int queueSize, String[] constantTags, StatsDClientErrorHandler errorHandler, String entityID) throws StatsDClientException {
        this(prefix, queueSize, constantTags, errorHandler, NonBlockingStatsDClient.staticStatsDAddressResolution(hostname, port), 100, -1, 1400, entityID);
    }

    public NonBlockingStatsDClient(String prefix, String hostname, int port, int queueSize, String[] constantTags, StatsDClientErrorHandler errorHandler, int maxPacketSizeBytes) throws StatsDClientException {
        this(prefix, queueSize, constantTags, errorHandler, NonBlockingStatsDClient.staticStatsDAddressResolution(hostname, port), 100, -1, maxPacketSizeBytes, null);
    }

    public NonBlockingStatsDClient(String prefix, String hostname, int port, int queueSize, int timeout, int bufferSize, String[] constantTags, StatsDClientErrorHandler errorHandler) throws StatsDClientException {
        this(prefix, queueSize, constantTags, errorHandler, NonBlockingStatsDClient.staticStatsDAddressResolution(hostname, port), timeout, bufferSize);
    }

    public NonBlockingStatsDClient(String prefix, int queueSize, String[] constantTags, StatsDClientErrorHandler errorHandler, Callable<SocketAddress> addressLookup) throws StatsDClientException {
        this(prefix, queueSize, constantTags, errorHandler, addressLookup, 100, -1, 1400, null);
    }

    public NonBlockingStatsDClient(String prefix, int queueSize, String[] constantTags, StatsDClientErrorHandler errorHandler, Callable<SocketAddress> addressLookup, int timeout, int bufferSize) throws StatsDClientException {
        this(prefix, queueSize, constantTags, errorHandler, addressLookup, timeout, bufferSize, 1400, null);
    }

    public NonBlockingStatsDClient(String prefix, int queueSize, String[] constantTags, StatsDClientErrorHandler errorHandler, Callable<SocketAddress> addressLookup, int timeout, int bufferSize, int maxPacketSizeBytes) throws StatsDClientException {
        this(prefix, queueSize, constantTags, errorHandler, addressLookup, timeout, bufferSize, maxPacketSizeBytes, null);
    }

    public NonBlockingStatsDClient(String prefix, int queueSize, String[] constantTags, StatsDClientErrorHandler errorHandler, Callable<SocketAddress> addressLookup, int timeout, int bufferSize, int maxPacketSizeBytes, String entityID) throws StatsDClientException {
        this.prefix = prefix != null && !prefix.isEmpty() ? prefix + "." : "";
        this.handler = errorHandler == null ? NO_OP_HANDLER : errorHandler;
        if (constantTags != null && constantTags.length == 0) {
            constantTags = null;
        }
        this.constantTagsRendered = (constantTags = this.updateTagsWithEntityID(constantTags, entityID)) != null ? NonBlockingStatsDClient.tagString(constantTags, null) : null;
        try {
            SocketAddress address = addressLookup.call();
            if (address instanceof UnixSocketAddress) {
                this.clientChannel = UnixDatagramChannel.open();
                if (timeout > 0) {
                    this.clientChannel.setOption(UnixSocketOptions.SO_SNDTIMEO, (Object)timeout);
                }
                if (bufferSize > 0) {
                    this.clientChannel.setOption(UnixSocketOptions.SO_SNDBUF, (Object)bufferSize);
                }
            } else {
                this.clientChannel = DatagramChannel.open();
            }
        }
        catch (Exception e) {
            throw new StatsDClientException("Failed to start StatsD client", e);
        }
        this.statsDSender = this.createSender(addressLookup, queueSize, this.handler, this.clientChannel, maxPacketSizeBytes);
        this.executor.submit(this.statsDSender);
    }

    protected StatsDSender createSender(Callable<SocketAddress> addressLookup, int queueSize, StatsDClientErrorHandler handler, DatagramChannel clientChannel, int maxPacketSizeBytes) {
        return new StatsDSender(addressLookup, queueSize, handler, clientChannel, maxPacketSizeBytes);
    }

    @Override
    public void stop() {
        try {
            this.statsDSender.shutdown();
            this.executor.shutdown();
            try {
                this.executor.awaitTermination(30L, TimeUnit.SECONDS);
                if (!this.executor.isTerminated()) {
                    this.executor.shutdownNow();
                }
            }
            catch (Exception e) {
                this.handler.handle(e);
                if (!this.executor.isTerminated()) {
                    this.executor.shutdownNow();
                }
            }
        }
        catch (Exception e) {
            this.handler.handle(e);
        }
        finally {
            if (this.clientChannel != null) {
                try {
                    this.clientChannel.close();
                }
                catch (IOException e) {
                    this.handler.handle(e);
                }
            }
        }
    }

    @Override
    public void close() {
        this.stop();
    }

    static String tagString(String[] tags, String tagPrefix) {
        StringBuilder sb;
        if (tagPrefix != null) {
            if (tags == null || tags.length == 0) {
                return tagPrefix;
            }
            sb = new StringBuilder(tagPrefix);
            sb.append(",");
        } else {
            if (tags == null || tags.length == 0) {
                return "";
            }
            sb = new StringBuilder("|#");
        }
        for (int n = tags.length - 1; n >= 0; --n) {
            sb.append(tags[n]);
            if (n <= 0) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    String tagString(String[] tags) {
        return NonBlockingStatsDClient.tagString(tags, this.constantTagsRendered);
    }

    @Override
    public void count(String aspect, long delta, String ... tags) {
        this.send(this.prefix + aspect + ":" + delta + "|c" + this.tagString(tags));
    }

    @Override
    public void count(String aspect, long delta, double sampleRate, String ... tags) {
        if (this.isInvalidSample(sampleRate)) {
            return;
        }
        this.send(this.prefix + aspect + ":" + delta + "|c|@" + SAMPLE_RATE_FORMATTERS.get().format(sampleRate) + this.tagString(tags));
    }

    @Override
    public void count(String aspect, double delta, String ... tags) {
        this.send(this.prefix + aspect + ":" + NUMBER_FORMATTERS.get().format(delta) + "|c" + this.tagString(tags));
    }

    @Override
    public void count(String aspect, double delta, double sampleRate, String ... tags) {
        if (this.isInvalidSample(sampleRate)) {
            return;
        }
        this.send(this.prefix + aspect + ":" + NUMBER_FORMATTERS.get().format(delta) + "|c|@" + SAMPLE_RATE_FORMATTERS.get().format(sampleRate) + this.tagString(tags));
    }

    @Override
    public void incrementCounter(String aspect, String ... tags) {
        this.count(aspect, 1L, tags);
    }

    @Override
    public void incrementCounter(String aspect, double sampleRate, String ... tags) {
        this.count(aspect, 1L, sampleRate, tags);
    }

    @Override
    public void increment(String aspect, String ... tags) {
        this.incrementCounter(aspect, tags);
    }

    @Override
    public void increment(String aspect, double sampleRate, String ... tags) {
        this.incrementCounter(aspect, sampleRate, tags);
    }

    @Override
    public void decrementCounter(String aspect, String ... tags) {
        this.count(aspect, -1L, tags);
    }

    @Override
    public void decrementCounter(String aspect, double sampleRate, String ... tags) {
        this.count(aspect, -1L, sampleRate, tags);
    }

    @Override
    public void decrement(String aspect, String ... tags) {
        this.decrementCounter(aspect, tags);
    }

    @Override
    public void decrement(String aspect, double sampleRate, String ... tags) {
        this.decrementCounter(aspect, sampleRate, tags);
    }

    @Override
    public void recordGaugeValue(String aspect, double value, String ... tags) {
        this.send(this.prefix + aspect + ":" + NUMBER_FORMATTERS.get().format(value) + "|g" + this.tagString(tags));
    }

    @Override
    public void recordGaugeValue(String aspect, double value, double sampleRate, String ... tags) {
        if (this.isInvalidSample(sampleRate)) {
            return;
        }
        this.send(this.prefix + aspect + ":" + NUMBER_FORMATTERS.get().format(value) + "|g|@" + SAMPLE_RATE_FORMATTERS.get().format(sampleRate) + this.tagString(tags));
    }

    @Override
    public void gauge(String aspect, double value, String ... tags) {
        this.recordGaugeValue(aspect, value, tags);
    }

    @Override
    public void gauge(String aspect, double value, double sampleRate, String ... tags) {
        this.recordGaugeValue(aspect, value, sampleRate, tags);
    }

    @Override
    public void recordGaugeValue(String aspect, long value, String ... tags) {
        this.send(this.prefix + aspect + ":" + value + "|g" + this.tagString(tags));
    }

    @Override
    public void recordGaugeValue(String aspect, long value, double sampleRate, String ... tags) {
        if (this.isInvalidSample(sampleRate)) {
            return;
        }
        this.send(this.prefix + aspect + ":" + value + "|g|@" + SAMPLE_RATE_FORMATTERS.get().format(sampleRate) + this.tagString(tags));
    }

    @Override
    public void gauge(String aspect, long value, String ... tags) {
        this.recordGaugeValue(aspect, value, tags);
    }

    @Override
    public void gauge(String aspect, long value, double sampleRate, String ... tags) {
        this.recordGaugeValue(aspect, value, sampleRate, tags);
    }

    @Override
    public void recordExecutionTime(String aspect, long timeInMs, String ... tags) {
        this.send(this.prefix + aspect + ":" + timeInMs + "|ms" + this.tagString(tags));
    }

    @Override
    public void recordExecutionTime(String aspect, long timeInMs, double sampleRate, String ... tags) {
        if (this.isInvalidSample(sampleRate)) {
            return;
        }
        this.send(this.prefix + aspect + ":" + timeInMs + "|ms|@" + SAMPLE_RATE_FORMATTERS.get().format(sampleRate) + this.tagString(tags));
    }

    @Override
    public void time(String aspect, long value, String ... tags) {
        this.recordExecutionTime(aspect, value, tags);
    }

    @Override
    public void time(String aspect, long value, double sampleRate, String ... tags) {
        this.recordExecutionTime(aspect, value, sampleRate, tags);
    }

    @Override
    public void recordHistogramValue(String aspect, double value, String ... tags) {
        this.send(this.prefix + aspect + ":" + NUMBER_FORMATTERS.get().format(value) + "|h" + this.tagString(tags));
    }

    @Override
    public void recordHistogramValue(String aspect, double value, double sampleRate, String ... tags) {
        if (this.isInvalidSample(sampleRate)) {
            return;
        }
        this.send(this.prefix + aspect + ":" + NUMBER_FORMATTERS.get().format(value) + "|h|@" + SAMPLE_RATE_FORMATTERS.get().format(sampleRate) + this.tagString(tags));
    }

    @Override
    public void histogram(String aspect, double value, String ... tags) {
        this.recordHistogramValue(aspect, value, tags);
    }

    @Override
    public void histogram(String aspect, double value, double sampleRate, String ... tags) {
        this.recordHistogramValue(aspect, value, sampleRate, tags);
    }

    @Override
    public void recordHistogramValue(String aspect, long value, String ... tags) {
        this.send(this.prefix + aspect + ":" + value + "|h" + this.tagString(tags));
    }

    @Override
    public void recordHistogramValue(String aspect, long value, double sampleRate, String ... tags) {
        if (this.isInvalidSample(sampleRate)) {
            return;
        }
        this.send(this.prefix + aspect + ":" + value + "|h|@" + SAMPLE_RATE_FORMATTERS.get().format(sampleRate) + this.tagString(tags));
    }

    @Override
    public void histogram(String aspect, long value, String ... tags) {
        this.recordHistogramValue(aspect, value, tags);
    }

    @Override
    public void histogram(String aspect, long value, double sampleRate, String ... tags) {
        this.recordHistogramValue(aspect, value, sampleRate, tags);
    }

    @Override
    public void recordDistributionValue(String aspect, double value, String ... tags) {
        this.send(this.prefix + aspect + ":" + NUMBER_FORMATTERS.get().format(value) + "|d" + this.tagString(tags));
    }

    @Override
    public void recordDistributionValue(String aspect, double value, double sampleRate, String ... tags) {
        if (this.isInvalidSample(sampleRate)) {
            return;
        }
        this.send(this.prefix + aspect + ":" + NUMBER_FORMATTERS.get().format(value) + "|d|@" + SAMPLE_RATE_FORMATTERS.get().format(sampleRate) + this.tagString(tags));
    }

    @Override
    public void distribution(String aspect, double value, String ... tags) {
        this.recordDistributionValue(aspect, value, tags);
    }

    @Override
    public void distribution(String aspect, double value, double sampleRate, String ... tags) {
        this.recordDistributionValue(aspect, value, sampleRate, tags);
    }

    @Override
    public void recordDistributionValue(String aspect, long value, String ... tags) {
        this.send(this.prefix + aspect + ":" + value + "|d" + this.tagString(tags));
    }

    @Override
    public void recordDistributionValue(String aspect, long value, double sampleRate, String ... tags) {
        if (this.isInvalidSample(sampleRate)) {
            return;
        }
        this.send(this.prefix + aspect + ":" + value + "|d|@" + SAMPLE_RATE_FORMATTERS.get().format(sampleRate) + this.tagString(tags));
    }

    @Override
    public void distribution(String aspect, long value, String ... tags) {
        this.recordDistributionValue(aspect, value, tags);
    }

    @Override
    public void distribution(String aspect, long value, double sampleRate, String ... tags) {
        this.recordDistributionValue(aspect, value, sampleRate, tags);
    }

    private String eventMap(Event event) {
        String sourceTypeName;
        String alertType;
        String priority;
        String aggregationKey;
        String hostname;
        StringBuilder res = new StringBuilder("");
        long millisSinceEpoch = event.getMillisSinceEpoch();
        if (millisSinceEpoch != -1L) {
            res.append("|d:").append(millisSinceEpoch / 1000L);
        }
        if ((hostname = event.getHostname()) != null) {
            res.append("|h:").append(hostname);
        }
        if ((aggregationKey = event.getAggregationKey()) != null) {
            res.append("|k:").append(aggregationKey);
        }
        if ((priority = event.getPriority()) != null) {
            res.append("|p:").append(priority);
        }
        if ((alertType = event.getAlertType()) != null) {
            res.append("|t:").append(alertType);
        }
        if ((sourceTypeName = event.getSourceTypeName()) != null) {
            res.append("|s:").append(sourceTypeName);
        }
        return res.toString();
    }

    @Override
    public void recordEvent(Event event, String ... tags) {
        String title = this.escapeEventString(this.prefix + event.getTitle());
        String text = this.escapeEventString(event.getText());
        this.send("_e{" + title.length() + "," + text.length() + "}:" + title + "|" + text + this.eventMap(event) + this.tagString(tags));
    }

    private String escapeEventString(String title) {
        return title.replace("\n", "\\n");
    }

    @Override
    public void recordServiceCheckRun(ServiceCheck sc) {
        this.send(this.toStatsDString(sc));
    }

    private String[] updateTagsWithEntityID(String[] tags, String entityID) {
        if (entityID == null || entityID.trim().isEmpty()) {
            entityID = System.getenv(DD_ENTITY_ID_ENV_VAR);
        }
        if (entityID != null && !entityID.trim().isEmpty()) {
            String entityTag = "dd.internal.entity_id" + ":" + entityID;
            if (tags == null) {
                tags = new String[]{entityTag};
            } else {
                tags = Arrays.copyOf(tags, tags.length + 1);
                tags[tags.length - 1] = entityTag;
            }
        }
        return tags;
    }

    private static String getHostnameFromEnvVar() {
        String hostname = System.getenv(DD_AGENT_HOST_ENV_VAR);
        if (hostname == null) {
            throw new StatsDClientException("Failed to retrieve agent hostname from environment variable", null);
        }
        return hostname;
    }

    private static int getPortFromEnvVar(int defaultPort) {
        String statsDPortString = System.getenv(DD_DOGSTATSD_PORT_ENV_VAR);
        if (statsDPortString == null) {
            return defaultPort;
        }
        try {
            int statsDPort = Integer.parseInt(statsDPortString);
            return statsDPort;
        }
        catch (NumberFormatException e) {
            throw new StatsDClientException("Failed to parse DD_DOGSTATSD_PORTenvironment variable value", e);
        }
    }

    private String toStatsDString(ServiceCheck sc) {
        StringBuilder sb = new StringBuilder();
        sb.append("_sc|").append(sc.getName()).append("|").append(sc.getStatus());
        if (sc.getTimestamp() > 0) {
            sb.append("|d:").append(sc.getTimestamp());
        }
        if (sc.getHostname() != null) {
            sb.append("|h:").append(sc.getHostname());
        }
        sb.append(this.tagString(sc.getTags()));
        if (sc.getMessage() != null) {
            sb.append("|m:").append(sc.getEscapedMessage());
        }
        return sb.toString();
    }

    @Override
    public void serviceCheck(ServiceCheck sc) {
        this.recordServiceCheckRun(sc);
    }

    @Override
    public void recordSetValue(String aspect, String value, String ... tags) {
        this.send(this.prefix + aspect + ":" + value + "|s" + this.tagString(tags));
    }

    private void send(String message) {
        this.statsDSender.send(message);
    }

    private boolean isInvalidSample(double sampleRate) {
        return sampleRate != 1.0 && ThreadLocalRandom.current().nextDouble() > sampleRate;
    }

    public static Callable<SocketAddress> volatileAddressResolution(final String hostname, final int port) {
        return new Callable<SocketAddress>(){

            @Override
            public SocketAddress call() throws UnknownHostException {
                if (port == 0) {
                    return new UnixSocketAddress(hostname);
                }
                return new InetSocketAddress(InetAddress.getByName(hostname), port);
            }
        };
    }

    public static Callable<SocketAddress> staticAddressResolution(String hostname, int port) throws Exception {
        final SocketAddress address = NonBlockingStatsDClient.volatileAddressResolution(hostname, port).call();
        return new Callable<SocketAddress>(){

            @Override
            public SocketAddress call() {
                return address;
            }
        };
    }

    private static Callable<SocketAddress> staticStatsDAddressResolution(String hostname, int port) throws StatsDClientException {
        try {
            if (hostname == null) {
                hostname = NonBlockingStatsDClient.getHostnameFromEnvVar();
                if (port == 0) {
                    port = NonBlockingStatsDClient.getPortFromEnvVar(8125);
                }
            }
            return NonBlockingStatsDClient.staticAddressResolution(hostname, port);
        }
        catch (Exception e) {
            throw new StatsDClientException("Failed to lookup StatsD host", e);
        }
    }
}

