/*
 * Decompiled with CFR 0.152.
 */
package com.timgroup.statsd;

import com.timgroup.statsd.BufferPool;
import com.timgroup.statsd.StatsDClientErrorHandler;
import com.timgroup.statsd.Telemetry;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class StatsDSender {
    private final Callable<SocketAddress> addressLookup;
    private final SocketAddress address;
    private final DatagramChannel clientChannel;
    private final StatsDClientErrorHandler handler;
    private final BufferPool pool;
    private final BlockingQueue<ByteBuffer> buffers;
    private static final int WAIT_SLEEP_MS = 10;
    protected final ThreadFactory threadFactory;
    protected final Thread[] workers;
    private final CountDownLatch endSignal;
    private volatile boolean shutdown;
    private volatile Telemetry telemetry;

    StatsDSender(Callable<SocketAddress> addressLookup, DatagramChannel clientChannel, StatsDClientErrorHandler handler, BufferPool pool, BlockingQueue<ByteBuffer> buffers, int workers, ThreadFactory threadFactory) throws Exception {
        this.pool = pool;
        this.buffers = buffers;
        this.handler = handler;
        this.threadFactory = threadFactory;
        this.workers = new Thread[workers];
        this.addressLookup = addressLookup;
        this.address = addressLookup.call();
        this.clientChannel = clientChannel;
        this.endSignal = new CountDownLatch(workers);
    }

    public void setTelemetry(Telemetry telemetry) {
        this.telemetry = telemetry;
    }

    public Telemetry getTelemetry() {
        return this.telemetry;
    }

    void startWorkers(String namePrefix) {
        for (int i = 0; i < this.workers.length; ++i) {
            this.workers[i] = this.threadFactory.newThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        StatsDSender.this.sendLoop();
                    }
                    finally {
                        StatsDSender.this.endSignal.countDown();
                    }
                }
            });
            this.workers[i].setName(namePrefix + (i + 1));
            this.workers[i].start();
        }
    }

    void sendLoop() {
        ByteBuffer buffer = null;
        Telemetry telemetry = this.getTelemetry();
        while (!this.buffers.isEmpty() || !this.shutdown) {
            int sizeOfBuffer = 0;
            try {
                if (buffer != null) {
                    buffer.clear();
                    this.pool.put(buffer);
                }
                if ((buffer = this.buffers.poll(10L, TimeUnit.MILLISECONDS)) == null) continue;
                sizeOfBuffer = buffer.position();
                buffer.flip();
                int sentBytes = this.clientChannel.send(buffer, this.address);
                if (sizeOfBuffer != sentBytes) {
                    throw new IOException(String.format("Could not send stat %s entirely to %s. Only sent %d out of %d bytes", buffer.toString(), this.address.toString(), sentBytes, sizeOfBuffer));
                }
                if (telemetry == null) continue;
                telemetry.incrBytesSent(sizeOfBuffer);
                telemetry.incrPacketSent(1);
            }
            catch (InterruptedException e) {
                if (!this.shutdown) continue;
                break;
            }
            catch (Exception e) {
                if (telemetry != null) {
                    telemetry.incrBytesDropped(sizeOfBuffer);
                    telemetry.incrPacketDropped(1);
                }
                this.handler.handle(e);
            }
        }
    }

    void shutdown() {
        this.shutdown = true;
        for (int i = 0; i < this.workers.length; ++i) {
            this.workers[i].interrupt();
        }
    }

    boolean awaitUntil(long deadline) {
        while (true) {
            long remaining = deadline - System.currentTimeMillis();
            try {
                return this.endSignal.await(remaining, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

