/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.llmobs;

import datadog.trace.api.llmobs.LLMObsSpan;
import datadog.trace.api.llmobs.noop.NoOpLLMObsEvalProcessor;
import datadog.trace.api.llmobs.noop.NoOpLLMObsSpanFactory;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class LLMObs {
    protected static LLMObsSpanFactory SPAN_FACTORY = NoOpLLMObsSpanFactory.INSTANCE;
    protected static LLMObsEvalProcessor EVAL_PROCESSOR = NoOpLLMObsEvalProcessor.INSTANCE;

    protected LLMObs() {
    }

    public static LLMObsSpan startLLMSpan(String spanName, String modelName, String modelProvider, @Nullable String mlApp, @Nullable String sessionId) {
        return SPAN_FACTORY.startLLMSpan(spanName, modelName, modelProvider, mlApp, sessionId);
    }

    public static LLMObsSpan startAgentSpan(String spanName, @Nullable String mlApp, @Nullable String sessionId) {
        return SPAN_FACTORY.startAgentSpan(spanName, mlApp, sessionId);
    }

    public static LLMObsSpan startToolSpan(String spanName, @Nullable String mlApp, @Nullable String sessionId) {
        return SPAN_FACTORY.startToolSpan(spanName, mlApp, sessionId);
    }

    public static LLMObsSpan startTaskSpan(String spanName, @Nullable String mlApp, @Nullable String sessionId) {
        return SPAN_FACTORY.startTaskSpan(spanName, mlApp, sessionId);
    }

    public static LLMObsSpan startWorkflowSpan(String spanName, @Nullable String mlApp, @Nullable String sessionId) {
        return SPAN_FACTORY.startWorkflowSpan(spanName, mlApp, sessionId);
    }

    public static void SubmitEvaluation(LLMObsSpan llmObsSpan, String label, String categoricalValue, Map<String, Object> tags) {
        EVAL_PROCESSOR.SubmitEvaluation(llmObsSpan, label, categoricalValue, tags);
    }

    public static void SubmitEvaluation(LLMObsSpan llmObsSpan, String label, String categoricalValue, String mlApp, Map<String, Object> tags) {
        EVAL_PROCESSOR.SubmitEvaluation(llmObsSpan, label, categoricalValue, mlApp, tags);
    }

    public static void SubmitEvaluation(LLMObsSpan llmObsSpan, String label, double scoreValue, Map<String, Object> tags) {
        EVAL_PROCESSOR.SubmitEvaluation(llmObsSpan, label, scoreValue, tags);
    }

    public static void SubmitEvaluation(LLMObsSpan llmObsSpan, String label, double scoreValue, String mlApp, Map<String, Object> tags) {
        EVAL_PROCESSOR.SubmitEvaluation(llmObsSpan, label, scoreValue, mlApp, tags);
    }

    public static class LLMMessage {
        private String role;
        private String content;
        private List<ToolCall> toolCalls;

        public static LLMMessage from(String role, String content, List<ToolCall> toolCalls) {
            return new LLMMessage(role, content, toolCalls);
        }

        public static LLMMessage from(String role, String content) {
            return new LLMMessage(role, content);
        }

        private LLMMessage(String role, String content, List<ToolCall> toolCalls) {
            this.role = role;
            this.content = content;
            this.toolCalls = toolCalls;
        }

        private LLMMessage(String role, String content) {
            this.role = role;
            this.content = content;
        }

        public String getRole() {
            return this.role;
        }

        public String getContent() {
            return this.content;
        }

        public List<ToolCall> getToolCalls() {
            return this.toolCalls;
        }
    }

    public static class ToolCall {
        private String name;
        private String type;
        private String toolId;
        private Map<String, Object> arguments;

        public static ToolCall from(String name, String type, String toolId, Map<String, Object> arguments) {
            return new ToolCall(name, type, toolId, arguments);
        }

        private ToolCall(String name, String type, String toolId, Map<String, Object> arguments) {
            this.name = name;
            this.type = type;
            this.toolId = toolId;
            this.arguments = arguments;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getToolId() {
            return this.toolId;
        }

        public Map<String, Object> getArguments() {
            return this.arguments;
        }
    }

    public static interface LLMObsEvalProcessor {
        public void SubmitEvaluation(LLMObsSpan var1, String var2, double var3, Map<String, Object> var5);

        public void SubmitEvaluation(LLMObsSpan var1, String var2, double var3, String var5, Map<String, Object> var6);

        public void SubmitEvaluation(LLMObsSpan var1, String var2, String var3, Map<String, Object> var4);

        public void SubmitEvaluation(LLMObsSpan var1, String var2, String var3, String var4, Map<String, Object> var5);
    }

    public static interface LLMObsSpanFactory {
        public LLMObsSpan startLLMSpan(String var1, String var2, String var3, @Nullable String var4, @Nullable String var5);

        public LLMObsSpan startAgentSpan(String var1, @Nullable String var2, @Nullable String var3);

        public LLMObsSpan startToolSpan(String var1, @Nullable String var2, @Nullable String var3);

        public LLMObsSpan startTaskSpan(String var1, @Nullable String var2, @Nullable String var3);

        public LLMObsSpan startWorkflowSpan(String var1, @Nullable String var2, @Nullable String var3);
    }
}

