/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import datadog.trace.api.EventTracker;
import datadog.trace.api.Tracer;
import datadog.trace.api.interceptor.TraceInterceptor;
import datadog.trace.api.internal.InternalTracer;
import java.util.ArrayList;
import java.util.Collection;

public class GlobalTracer {
    private static final Tracer NO_OP = new Tracer(){

        @Override
        public String getTraceId() {
            return "0";
        }

        @Override
        public String getSpanId() {
            return "0";
        }

        @Override
        public boolean addTraceInterceptor(TraceInterceptor traceInterceptor) {
            return false;
        }
    };
    private static final Collection<Callback> installationCallbacks = new ArrayList<Callback>();
    private static Tracer provider = NO_OP;
    private static EventTracker eventTracker = EventTracker.NO_EVENT_TRACKER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerIfAbsent(Tracer p) {
        if (p == null || p == NO_OP) {
            throw new IllegalArgumentException();
        }
        Collection<Callback> collection = installationCallbacks;
        synchronized (collection) {
            if (provider == NO_OP) {
                provider = p;
                for (Callback callback : installationCallbacks) {
                    callback.installed(p);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forceRegister(Tracer tracer) {
        if (tracer == null || tracer == NO_OP) {
            throw new IllegalArgumentException();
        }
        Collection<Callback> collection = installationCallbacks;
        synchronized (collection) {
            provider = tracer;
            for (Callback callback : installationCallbacks) {
                callback.installed(tracer);
            }
        }
    }

    public static Tracer get() {
        return provider;
    }

    public static EventTracker getEventTracker() {
        if (eventTracker == EventTracker.NO_EVENT_TRACKER && provider instanceof InternalTracer) {
            eventTracker = new EventTracker((InternalTracer)((Object)provider));
        }
        return eventTracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void registerInstallationCallback(Callback callback) {
        Collection<Callback> collection = installationCallbacks;
        synchronized (collection) {
            installationCallbacks.add(callback);
            if (provider != NO_OP) {
                callback.installed(provider);
            }
        }
    }

    static interface Callback {
        public void installed(Tracer var1);
    }
}

